% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psych_kxi_example.R
\name{psych_kxi_ensemble_models}
\alias{psych_kxi_ensemble_models}
\title{Example pipeline for ensemble models}
\usage{
psych_kxi_ensemble_models(
  m_data,
  ...,
  n_models = 4,
  metrics = NULL,
  metrics_exclude = NULL,
  model_subsample = c(0.1, 0.2, 0.5),
  n_models_subsample = 10
)
}
\arguments{
\item{m_data}{Data matrix Data frame returned by optics}

\item{...}{Passed to function psych_kxi_pipeline}

\item{n_models}{Number of best models to return}

\item{metrics}{Names of metrics to use. Any of those computed by
opticskxi_pipeline, e.g. 'sindex', 'ch', 'dunn',
'dunn2', 'widestgap', 'entropy' etc.
NULL for all (8).}

\item{metrics_exclude}{Names of metrics to exclude.
Typically used with metrics = NULL. E.g. 'entropy'.}

\item{model_subsample}{Ratios of best models to consider.}

\item{n_models_subsample}{Number of best models when subsampling.}
}
\value{
Input parameter data frame with with results binded in columns
        optics, clusters and metrics.
        Subsetted to best models according to ensemble metrics.
}
\description{
Example pipeline for ensemble models on mental health related natural
language processing
}
\examples{
data('m_psychwords')
m_psychwords = m_psychwords[1:200, 1:20]

df_params = expand.grid(n_xi = 4:5, pts = c(5, 10), dist = 'cosine',
                        dim_red = 'ICA', n_dimred_comp = 5)

df_kxi = psych_kxi_ensemble_models(m_psychwords, df_params,
                                   n_min_clusters = 2,
                                   n_models = 4,
                                   metrics = c('avg.silwidth', 'dunn'),
                                   model_subsample = c(0.4, 0.6),
                                   n_models_subsample = 4)

}
