% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizer.R, R/package.R
\docType{package}
\name{optimizeR}
\alias{optimizeR}
\alias{optimizeR-package}
\title{Optimization}
\usage{
optimizeR(optimizer = set_optimizer_nlm(), f, p, ...)
}
\arguments{
\item{optimizer}{An object of class \code{optimizer}.}

\item{f}{The function to be optimized, returning a single numeric value.
Its first argument must be a numeric vector of the length of \code{p}
followed by any other arguments specified by the \code{...} argument.}

\item{p}{A numeric vector with starting parameter values for the optimization.}

\item{...}{Additional arguments to be passed to \code{f}.}
}
\value{
A list, containing the elements
\itemize{
\item \code{v}, the value of the estimated optimum of \code{f},
\item \code{z}, the parameter vector where the optimum of \code{f} is obtained,
\item \code{time}, the total optimization time (as a \code{difftime} object),
and additional output elements of the optimizer (if not excluded by the
\code{out_ign} element via \code{\link{set_optimizer}}).
}
}
\description{
This function performs numerical optimization using an \code{optimizer}
object.

This package provides a unified framework for numerical optimizer,
particularly for inputs and outputs.
}
\seealso{
\code{\link[=set_optimizer]{set_optimizer()}} for specifying an \code{optimizer} object.

Useful links:
\itemize{
  \item \url{https://github.com/loelschlaeger/optimizeR}
  \item Report bugs at \url{https://github.com/loelschlaeger/optimizeR/issues}
}

}
\author{
\strong{Maintainer}: Lennart Oelschläger \email{oelschlaeger.lennart@gmail.com} (\href{https://orcid.org/0000-0001-5421-9313}{ORCID})

Other contributors:
\itemize{
  \item Marius Ötting \email{marius.oetting@uni-bielefeld.de} (\href{https://orcid.org/0000-0002-9373-0365}{ORCID}) [contributor]
}

}
\keyword{internal}
