% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{dv}
\alias{dv}
\title{Double Vertical Spread Analytics}
\usage{
dv(s, x1, x2, x3, x4, t, r, sigma, sigma2 = sigma, sigma3 = sigma,
  sigma4 = sigma, vol = sigma, d = 0)
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x1}{Strike price of the lower strike (long) put option}

\item{x2}{Strike price of the higher strike (short) put option}

\item{x3}{Strike price of the lower strike (short) call option}

\item{x4}{Strike price of the higher strike (long) call option}

\item{t}{Time to expiration in years}

\item{r}{Annual continuously compounded risk-free rate}

\item{sigma}{Implied volatility of the lower strike (long) put option (annualized)}

\item{sigma2}{Implied volatility of the higher strike (short) put option (annualized)}

\item{sigma3}{Implied volatility of the lower strike (short) call option (annualized)}

\item{sigma4}{Implied volatility of the higher strike (long) call option (annualized)}

\item{vol}{Manual over-ride for the volatility of the underlying asset (annualized)}

\item{d}{Annual continuously compounded dividend yield}
}
\value{
Returns a data.frame
}
\description{
Calculates the key analytics of a Double Vertical Credit Spread
}
\examples{
dv(s = 100, x1 = 90, x2 = 95, x3 = 105, x4 = 110, t = 0.08, r = 0.02, sigma = 0.2, vol = 0.3)
}
