% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{prob.above}
\alias{prob.above}
\title{Probability Above}
\usage{
prob.above(spot, lower, mean = 0, dsd, dte, p, quantile = FALSE)
}
\arguments{
\item{spot}{Current price of the underlying asset}

\item{lower}{Lower price of the range}

\item{mean}{The average daily price movement, default = 0}

\item{dsd}{Daily standard deviation of the underlying returns (Annual vol/sqrt(256))}

\item{dte}{Days until expiration, designated time frame}

\item{p}{Designated probability}

\item{quantile}{Logical. If True, calculates the price the asset will remain above, given the designated probability}
}
\value{
Returns a probability (if quantile = FALSE), Returns a data.frame (if quantile = TRUE)
}
\description{
Calculates the probability of the underlying asset value remaining above a price level in a designated time frame, given the daily standard devaiation of the underlying returns.
}
\details{
This function has two separate possible operations:
1. Calculates the probability of the underlying asset value remaining above a price level in a designated time frame, given the daily standard devaiation of the underlying returns.
2. Calculates the price the asset will remain above, given the designated probability
}
\examples{
prob.above(spot = 100, lower = 110, mean = 0, dsd = 0.01, dte = 45)
prob.above(spot = 100, mean = 0, dsd = 0.01, dte = 45, p = 0.75, quantile = TRUE)
}
