% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_funs.R
\name{vbgf}
\alias{vbgf}
\title{Basic von Bertalanffy growth function (VBGF)}
\usage{
vbgf(time, linf, k, t0)
}
\arguments{
\item{time}{Time at which to calculate size}

\item{linf}{The \ifelse{html}{\out{L<sub>&infin;</sub>}}{\eqn{L_\infty}}
parameter of the VBGF}

\item{k}{The k parameter of the VBGF}

\item{t0}{The \ifelse{html}{\out{t<sub>0</sub>}}{\eqn{t_0}}}
}
\value{
A numeric vector of lengths given the age (or amount of time) and
parameters
}
\description{
Basic von Bertalanffy growth function (VBGF)
}
\examples{
curve(vbgf(x, 30, 0.25, -0.2), 0, 10)
curve(vbgf(x, 30, (0.25 / 365), -0.2), 0, 10 * 365)
}
