\name{minExactMatch}
\alias{minExactMatch}
\title{Find the minimal exact match factors that will be feasible.}
\usage{
  minExactMatch(x, scores = NULL, width = NULL, ...)
}
\arguments{
  \item{x}{The object for dispatching.}

  \item{scores}{Optional vector of scores that will be
  checked against a caliper width.}

  \item{width}{Optional width of a caliper to place on the
  scores.}

  \item{...}{Additional arguments for methods.}
}
\value{
  A factor grouping units, suitable for
  \code{\link{exactMatch}}.
}
\description{
  The \code{\link{exactMatch}} function creates a smaller
  matching problem by stratifying observations into smaller
  groups. For a problem that is larger than maximum allowed
  size, \code{minExatMatch} provides a way to find the
  smallest exact matching problem that will allow for
  matching.
}
\details{
  \code{x} is a formula of the form \code{Z ~ X1 + X2},
  where \code{Z} is indicates treatment or control status,
  and \code{X1} and \code{X2} are variables can be
  converted to factors. Any additional arguments are passed
  to \code{\link{model.frame}} (e.g., a \code{data}
  argument containing \code{Z}, \code{X1}, and \code{X2}).

  The the arguments \code{scores} and \code{width} must be
  passed together. The function will apply the caliper
  implied by the scores and the width while also adding in
  blocking factors.
}

