% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdist.R
\name{mdist}
\alias{mdist}
\alias{mdist.optmatch.dlist}
\alias{mdist.function}
\alias{mdist.formula}
\alias{mdist.glm}
\alias{mdist.bigglm}
\alias{mdist.numeric}
\title{(Deprecated, in favor of \code{\link{match_on}}) Create
  matching distances}
\usage{
mdist(x, structure.fmla = NULL, ...)

\method{mdist}{optmatch.dlist}(x, structure.fmla = NULL, ...)

\method{mdist}{function}(x, structure.fmla = NULL, data = NULL, ...)

\method{mdist}{formula}(x, structure.fmla = NULL, data = NULL,
  subset = NULL, ...)

\method{mdist}{glm}(x, structure.fmla = NULL,
  standardization.scale = mad, ...)

\method{mdist}{bigglm}(x, structure.fmla = NULL, data = NULL,
  standardization.scale = mad, ...)

\method{mdist}{numeric}(x, structure.fmla = NULL, trtgrp = NULL, ...)
}
\arguments{
\item{x}{The object to use as the basis for forming the mdist.
Methods exist for formulas, functions, and generalized linear
models.}

\item{structure.fmla}{A formula denoting the treatment variable on
the left hand side and an optional grouping expression on the
right hand side. For example, \code{z ~ 1} indicates no
grouping. \code{z ~ s} subsets the data only computing distances
within the subsets formed by \code{s}. See method notes, below,
for additional formula options.}

\item{...}{Additional method arguments. Most methods require a
'data' argument.}

\item{data}{Data where the variables references in `x` live.}

\item{subset}{If non-NULL, the subset of `data` to be used.}

\item{standardization.scale}{A function to scale the distances; by
default uses `mad`.}

\item{trtgrp}{Dummy variable for treatment group membership.}
}
\value{
Object of class \code{optmatch.dlist}, which is suitable
  to be given as \code{distance} argument to
  \code{\link{fullmatch}} or \code{\link{pairmatch}}.
}
\description{
Deprecated in favor of \code{\link{match_on}}
}
\details{
The \code{mdist} method provides three ways to construct a
matching distance (i.e., a distance matrix or suitably organized
list of such matrices): guided by a function, by a fitted model,
or by a formula.  The class of the first argument given to
\code{mdist} determines which of these methods is invoked.

The \code{mdist.function} method takes a function of two
arguments. When called, this function will receive the treatment
observations as the first argument and the control observations as
the second argument. As an example, the following computes the raw
differences between values of \code{t1} for treatment units (here,
nuclear plants with \code{pr==1}) and controls (here, plants with
\code{pr==0}), returning the result as a distance matrix:

\code{sdiffs <- function(treatments, controls) {
     abs(outer(treatments$t1, controls$t1, `-`))
   }
 }

The \code{mdist.function} method does similar things as the
 earlier optmatch function \code{makedist}, although the interface
 is a bit different.

The \code{mdist.formula} method computes the squared Mahalanobis
 distance between observations, with the right-hand side of the
 formula determining which variables contribute to the Mahalanobis
 distance. If matching is to be done within strata, the
 stratification can be communicated using either the
 \code{structure.fmla} argument (e.g. \code{~ grp}) or as part of
 the main formula (e.g. \code{z ~ x1 + x2 | grp}).

An \code{mdist.glm} method takes an argument of class \code{glm}
 as first argument.  It assumes that this object is a fitted
 propensity model, extracting distances on the linear propensity
 score (logits of the estimated conditional probabilities) and, by
 default, rescaling the distances by the reciprocal of the pooled
 s.d. of treatment- and control-group propensity scores.  (The
 scaling uses \code{mad}, for resistance to outliers, by default;
 this can be changed to the actual s.d., or rescaling can be
 skipped entirely, by setting argument
 \code{standardization.scale} to \code{sd} or \code{NULL},
 respectively.)  A \code{mdist.bigglm} method works analogously
 with \code{bigglm} objects, created by the \code{bigglm} function
 from package \sQuote{biglm}, which can handle bigger data sets
 than the ordinary glm function can.  In contrast with
 \code{mdist.glm} it requires additional \code{data} and
 \code{structure.fmla} arguments.  (If you have enough data to
 have to use \code{bigglm}, then you'll probably have to subgroup
 before matching to avoid memory problems. So you'll have to use
 the \code{structure.fmla} argument anyway.)
}
\references{
P.~R. Rosenbaum and D.~B. Rubin (1985),
  \sQuote{Constructing a control group using multivariate matched
  sampling methods that incorporate the propensity score},
  \emph{The American Statistician}, \bold{39} 33--38.
}
\seealso{
\code{\link{fullmatch}}, \code{\link{pairmatch}},
  \code{\link{match_on}}
}
\author{
Mark M. Fredrickson
}
\keyword{nonparametric}
