% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distUnion.R
\name{distUnion}
\alias{distUnion}
\title{Combine multiple distance specifications into a single distance specification.}
\usage{
distUnion(...)
}
\arguments{
\item{...}{The distance specifications (as created with with
\code{\link{match_on}}, \code{\link{exactMatch}}, or other distance
creation function).}
}
\value{
An InfinitySparseMatrix object with all treated and control
units from the arguments combined. Duplicate entries are resolved
in favor of the earliest argument (e.g., \code{distUnion(A, B)}
will favor entries in \code{A} over entries in \code{B}).
}
\description{
Creates a new distance specification from the union of two or more
distance specifications. The constituent distances specifications
may have overlapping treated and control units (identified by the
\code{rownames} and \code{colnames} respectively).
}
\details{
For combining multiple distance specifications with common
controls, but different treated units, \code{\link{rbind}} provides
a way to combine the different objects. Likewise,
\code{\link{cbind}} provides a way to combine distance
specifications over common treated units, but different control
units.

\code{distUnion} can combine distance units that have common
treated and control units into a coherent single distance
object. If there are duplicate treated-control entries in multiple
input distances, the first entry will be used.
}
\seealso{
\code{\link{match_on}}, \code{\link{exactMatch}},
\code{\link{fullmatch}}, \code{\link{pairmatch}},
\code{\link{cbind}}, \code{\link{rbind}}
}

