% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcamentoBR.R
\name{despesaDetalhada}
\alias{despesaDetalhada}
\title{Download expenditure data from the Brazilian federal budget.}
\usage{
despesaDetalhada(
  exercicio = .last_year(),
  Esfera = FALSE,
  Orgao = FALSE,
  UO = FALSE,
  Funcao = FALSE,
  Subfuncao = FALSE,
  Programa = FALSE,
  Acao = FALSE,
  PlanoOrcamentario = FALSE,
  Subtitulo = FALSE,
  CategoriaEconomica = FALSE,
  GND = FALSE,
  ModalidadeAplicacao = FALSE,
  ElementoDespesa = FALSE,
  Fonte = FALSE,
  IdUso = FALSE,
  ResultadoPrimario = FALSE,
  valorPLOA = TRUE,
  valorLOA = TRUE,
  valorLOAmaisCredito = TRUE,
  valorEmpenhado = TRUE,
  valorLiquidado = TRUE,
  valorPago = TRUE,
  incluiDescricoes = TRUE,
  detalheMaximo = FALSE,
  ignoreSecureCertificate = FALSE,
  timeout = 0,
  print_url = FALSE
)
}
\arguments{
\item{exercicio}{A number. Indicates the year to which the extracted data refers. (Indica o ano a que se refere a extração)

The following parameters are Boolean values. If a parameter is set to \code{TRUE},
 the returned dataframe will be detailed according to the respective dimension.
 If a parameter is set to \code{FALSE}, the figures will be aggregated.

 (Os parâmetros que seguem são valores booleanos. Se um parâmetro estiver
 definido como \code{TRUE}, o dataframe retornado será detalhado de acordo com a
 respectiva dimensão. Se um parâmetro estiver definido como \code{FALSE},
 os valores serão agregados.)

* Dimensions (Nível de detalhamento)

QUALITATIVE CLASSIFICATION (CLASSIFICAÇÃO QUALITATIVA)

Classification by Budget segment (Classificação por Esfera)}

\item{Esfera}{Budget segment (Esfera Orçamentária)

Institutional Classification (Classificação Institucional)}

\item{Orgao}{Agency (Órgão)}

\item{UO}{Budgetary Unit (Unidade Orçamentária)

Functional Classification (Classificação Funcional)}

\item{Funcao}{Function (Função)}

\item{Subfuncao}{Subfunction (Subfunção)

Programmatic Structure (Classificação Programática)}

\item{Programa}{Program (Programa)}

\item{Acao}{Activity (Ação)}

\item{PlanoOrcamentario}{Budget Plan (Plano orçamentárip)}

\item{Subtitulo}{Subtitle (Subtítulo)

QUANTITATIVE CLASSIFICATION (CLASSIFICAÇÃO QUANTITATIVA)

Detailed Financial Programming (Componentes da programação financeira)}

\item{CategoriaEconomica}{Economic Category (categoria Econômica)}

\item{GND}{Nature of Expenditure (Grupo Natureza da Despesa)}

\item{ModalidadeAplicacao}{Application Mode (Modalidade de Aplicação)}

\item{ElementoDespesa}{Expenditure Element (Elemento da Despesa)}

\item{Fonte}{Fonte de Recursos (Source of Funds)}

\item{IdUso}{Resources used as a counterpart Identifier (Identificador de recursos utilizado como contrapartida)}

\item{ResultadoPrimario}{Primary Result Identifier (Idenfificador de efeito sobre o resultado primário da União)

The following parameters are Boolean values. If a parameter is set to \code{TRUE},
 the returned dataframe will include the respective figure. By default, all
 metrics are set to \code{TRUE}.

 (Os seguintes parâmetros são valores booleanos. Se um parâmetro estiver
 definido como \code{TRUE}, o dataframe retornado incluirá a respectiva métrica.
 Todas as métricas são definidas como TRUE por padrão.)}

\item{valorPLOA}{Annual Budget Bill value (Valor do PLOA)}

\item{valorLOA}{Annual Budget Law value - LOA (Valor da LOA)}

\item{valorLOAmaisCredito}{LOA value plus additional credits - Total authorized value (Valor da LOA adicionado de créditos adicionais)}

\item{valorEmpenhado}{Committed value (Valor empenhado)}

\item{valorLiquidado}{Verified value (Valor liquidado)}

\item{valorPago}{Paid value (Valor pago)}

\item{incluiDescricoes}{A Boolean. If the parameter is set to \code{TRUE},
the returned dataframe will include a column describing each selected dimension.
If the parameter is set to \code{FALSE}, only the dimension codes will be returned.
The default value is \code{TRUE}. (Se o parâmetro estiver definido como \code{TRUE},
o dataframe retornado incluirá uma coluna descrevendo cada dimensão
selecionada. Se o parâmetro estiver definido como \code{FALSE}, apenas os códigos
das dimensões serão retornados. O valor padrão é \code{TRUE}.)}

\item{detalheMaximo}{A Boolean. If the parameter is set to \code{TRUE}, the returned
dataframe will be disaggregated across all available dimensions, overriding
any dimension choices made by other parameters. If the parameter is set to
\code{FALSE}, only the selected dimensions will be returned. The default value is \code{FALSE}.
(Se o parâmetro estiver definido como \code{TRUE}, o dataframe retornado será
desagregado em todas as dimensões disponíveis, substituindo qualquer escolha
de dimensão feita por outros parâmetros. Se o parâmetro estiver definido como
\code{FALSE}, apenas as dimensões selecionadas serão retornadas. O valor padrão é
\code{FALSE}.)}

\item{ignoreSecureCertificate}{A Boolean. If the parameter is set to \code{TRUE},
the download of SIOP data will proceed while ignoring the secure certificate.
(Se o parâmetro estiver definido como \code{TRUE}, o download dos dados
do SIOP será realizado ignorando o certificado seguro.)}

\item{timeout}{An Integer. Milliseconds to server timeout. Values less than 1000 are
ignored by SIOP server. (Milisegundos até o timeout do servidor. Valores
menores que 1000 são ignorados pelo servidor.)}

\item{print_url}{A Boolean. If the parameter is set to \code{TRUE}, the function
prints the constructed url before reaching the SIOP endpooint. (Se o parâmetro estiver
definido como \code{TRUE}, a função exibe a url utilizanda antes de acessar o endpoint.)}
}
\value{
The dataframe contains the expenditure figures. The columns are based
 on the choices made in the parameters.

 PT-BR: O dataframe contém os valores de
 despesa. As colunas são baseadas nas escolhas feitas nos parâmetros.
}
\description{
This function downloads expenditure data from the Brazilian federal budget.
It resorts on the SIOP API. For more information on the Brazilian Budget,
please refer to the Budget Technical Manual, available in Portuguese at \href{https://www1.siop.planejamento.gov.br/mto/lib/exe/fetch.php/mto2025:mto2025.pdf}{Manual Técnico do Orçamento}.

PT-BR: Essa função faz o download dos dados da despesa do orçamento da União do Brasil.
Os dados são baixados por meio da API do SIOP. Para mais informação sobre o
orçamento brasileiro, não deixe de consultar o \href{https://www1.siop.planejamento.gov.br/mto/lib/exe/fetch.php/mto2025:mto2025.pdf}{Manual Técnico do Orçamento}.
}
\examples{
\dontrun{despesaDetalhada(2020, UO = "73901", valorPLOA = FALSE, detalheMaximo = TRUE)}

\dontrun{despesaDetalhada(exercicio = 2023, ResultadoPrimario = "6")}

}
