% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R, R/package_info.R
\docType{package}
\name{ordbetareg}
\alias{ordbetareg}
\title{Fit Ordered Beta Regression Model}
\usage{
ordbetareg(
  formula = NULL,
  data = NULL,
  phi_reg = FALSE,
  use_brm_multiple = FALSE,
  coef_prior_mean = 0,
  coef_prior_sd = 5,
  phi_prior = 0.1,
  dirichlet_prior = c(1, 1, 1),
  phi_coef_prior_mean = 0,
  phi_coef_prior_sd = 5,
  extra_prior = NULL,
  inits = "0",
  ...
)
}
\arguments{
\item{formula}{Either an R formula in the form response/DV ~ var1 + var2
etc. \emph{or} formula object as created/called by the \code{brms}
\link[brms:brmsformula]{brms::bf} function. *Please avoid using 0 or \code{Intercept} in the
formula definition.}

\item{data}{An R data frame or tibble containing the variables in the formula}

\item{phi_reg}{T/F. Whether you are including a linear model predicting
the dispersion  parameter, phi. Defaults to false.}

\item{use_brm_multiple}{(T/F) Whether the model should use
\link[brms:brm_multiple]{brms::brm_multiple} for multiple
imputation over multiple dataframes passed
as a list to the \code{data} argument}

\item{coef_prior_mean}{The mean of the Normal distribution prior on the
regression coefficients (for predicting the mean of the response).
Default is 0.}

\item{coef_prior_sd}{The SD of the Normal distribution prior on the
regression coefficients (for predicting the mean of the response).
Default is 5, which makes the prior weakly informative on the
logit scale.}

\item{phi_prior}{The mean parameter of the exponential prior on
phi, which determines the dispersion of the beta distribution. The
default is .1, which equals a mean of 10 and is thus weakly
informativce. If the response has very low variance (i.e. tightly)
clusters around a specific value, then increasing this prior may be
helpful. Checking the value of phi in the output of the model command
will reveal if 10 is too small.}

\item{dirichlet_prior}{A vector of three integers
corresponding to the prior parameters for the dirchlet distribution
(alpha parameter) governing the location of the cutpoints between
the components of the response (continuous vs. degenerate).
The default is 1 which puts equal probability on
degenerate versus continuous responses. Likely only needs to be
changed in a repeated sampling situation to stabilize the cutpoint
locations across samples.}

\item{phi_coef_prior_mean}{The mean of the Normal distribution prior on the
regression coefficients for predicting phi, the dispersion parameter.
Only useful if a linear model is being fit to phi.
Default is 0.}

\item{phi_coef_prior_sd}{The SD of the Normal distribution prior on the
regression coefficients for predicting phi, the dispersion parameter.
Only useful if a linear model is being fit to phi.
Default is 5, which makes the prior weakly informative on the
logit scale.}

\item{extra_prior}{An additional prior, such as a prior for a specific
regression coefficient, added to the model by passing one of the \code{brms}
functions \link[brms:set_prior]{brms::set_prior} or \link[brms:set_prior]{brms::prior_string} with appropriate
values.}

\item{inits}{This parameter is used to determine starting values for
the Stan sampler to begin Markov Chain Monte Carlo sampling. It is
set by default at 0 because the non-linear nature of beta regression
means that it is possible to begin with extreme values depending on the
scale of the covariates. Setting this to 0 helps the sampler find
starting values. It does, on the other hand, limit the ability to detect
convergence issues with Rhat statistics. If that is a concern, such as
with an experimental feature of \code{brms}, set this to \code{"random"} to get
more robust starting values (just be sure to scale the covariates so they are
not too large in absolute size).}

\item{...}{All other arguments passed on to the \code{brm} function}
}
\value{
A \code{brms} object fitted with the ordered beta regression distribution.
}
\description{
This function allows you to estimate an ordered beta regression model
via a formula syntax.

The \code{ordbetareg} package is essentially a wrapper around \code{brms} that
enables the ordered beta regression model to be fit. This model has
advantages over other alternatives for continous data with upper
and lower bounds, such as survey sliders, indexes,
dose-response relationships,
and visual analog scales (among others). The package allows for all of the
many \code{brms} regression modeling functions to be used with the ordered
beta regression distribution.
}
\details{
This function is a wrapper around the \link[brms:brm]{brms::brm} function, which is a
powerful Bayesian regression modeling engine using Stan. To fully explore
the options available, including dynamic and hierarchical modeling, please
see the documentation for the \code{brm} function above. As the ordered beta
regression model is currently not available in \code{brms} natively, this modeling
function allows a \code{brms} model to be fit with the ordered beta regression
distribution.

This function allows you to set priors on the dispersion parameter,
the cutpoints, and the regression coefficients (see below for options).
However, to add specific priors on individual covariates, you would need
to use the \link[brms:set_prior]{brms::set_prior} function by specifying an individual covariate
(see function documentation) and passing the result of the function call
to the \code{extra_prior} argument.

This function will also automatically normalize the outcome so that it
lies in the \[0,1\] interval, as required by beta regression. For furthur
information, see the documentation for the \link{normalize} function.

To learn more about how the package works, see the vignette by using
the command \code{browseVignettes(package='ordbetareg')}.

For more info about the distribution, see
this paper: https://osf.io/preprints/socarxiv/2sx6y/

To cite the package, please cite the following paper:

Kubinec, Robert. "Ordered Beta Regression: A Parsimonious, Well-Fitting Model for Continuous Data with Lower and Upper Bounds." \strong{Political Analysis}. 2022. Forthcoming.
}
\examples{
# load survey data that comes with the package

data("pew")

# prepare data

model_data <- select(pew,therm,
             education="F_EDUCCAT2_FINAL",
             region="F_CREGION_FINAL",
             income="F_INCOME_FINAL")

# It takes a while to fit the models. Run the code
# below if you want to load a saved fitted model from the
# package, otherwise use the model-fitting code

data("ord_fit_mean")

  \donttest{
  # fit the actual model

    ord_fit_mean <- ordbetareg(formula=therm ~ education + income +
    (1|region),
    data=model_data,
    cores=2,chains=2)
  }

# access values of the coefficients

summary(ord_fit_mean)
}
