% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{dordbeta}
\alias{dordbeta}
\title{Probability Density Function for the Ordered Beta Distribution}
\usage{
dordbeta(x = 0.9, mu = 0.5, phi = 1, cutpoints = c(-1, 1), log = FALSE)
}
\arguments{
\item{x}{Variates of the ordered beta distribution (should be in the [0,1] interval).}

\item{mu}{Value of the mean of the distribution.
Should be in the \(0,1\) interval (cannot be strictly equal to 0 or 1). If
length is greater than 1, should be of length x.}

\item{phi}{Value of the dispersion parameter. Should be strictly greater than 0. If
length is greater than 1, should be of length x.}

\item{cutpoints}{A vector of two numeric values for the cutpoints. Second value should}

\item{log}{where to return the log density
be strictly greater than the first value.}
}
\description{
This function will return the density of given variates of the
ordered beta distribution conditional on values for
the mean (\code{mu}), dispersion (\code{phi}) and cutpoints
governing the ratio of degenerate (discrete) to continuous
responses.
}
\examples{

# examine density (likelihood) of different possible values
# given fixed values for ordered beta parameters

x <- seq(0, 1, by=0.01)

x_dens <- dordbeta(x, mu = 0.3, phi=2, cutpoints=c(-2, 2))

# Most likely value for x is approx 1
# Note discontinuity in density function between continuous/discrete values
# density function is a combined PMF/PDF, so not a real PDF
# can though be used for MLE

plot(x_dens, x)

# discrete values should be compared to each other:
# prob of discrete 0 > prob of discrete 1

x_dens[x==0] > x_dens[x==1]
}
