% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_sinharcsinh.R
\name{order_sinharcsinh}
\alias{order_sinharcsinh}
\title{Random Sampling of Order Statistics from a Sinh-Arcsinh Distribution}
\usage{
order_sinharcsinh(size, k, mu, sigma, nu, tau, n, ...)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{k}{numeric, represents the Kth smallest value from a sample.}

\item{mu}{numeric, represents the location parameter values.}

\item{sigma}{numeric, represents scale parameter values.}

\item{nu}{numeric, represents skewness parameter values}

\item{tau}{numeric, represents kurtosis tau parameter values.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}

\item{...}{represents others parameters of a Sinh-Arcsinh distribution.}
}
\value{
A list with a random sample of order statistics from a Sinh-Arcsinh Distribution and the value of its join probability density function evaluated in the random sample.
}
\description{
\code{order_sinharcsinh} is used to obtain a random sample of order statistics from a Sinh-Arcsinh Distribution.
}
\examples{
library(orders)
# A sample of size 10 of the 3-th order statistics from a Sinh-Arcsinh Distribution
order_sinharcsinh(size=10,k=3,mu=0,sigma=1,nu=1,tau=2,n=30)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Ribgy, R. and Stasinopoulos, M. (2005) Generalized Additive Models for Location Scale and Shape, Journal of the Royal Statistical Society. Applied Statistics, Series C.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
