% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gfunction.R
\name{g_glf}
\alias{g_glf}
\title{Generalized logistic g function}
\usage{
g_glf(v, par)
}
\arguments{
\item{v}{vector of standardized scores from the continuous ordinal scale, 0<v<1}

\item{par}{vector of 3 elements: \code{M}, the offset, \code{B}, the slope of the curve, and \code{T}, the symmetry of the curve}
}
\value{
A vector of length equal to the length of \code{v}, with values \eqn{g(v)}.
}
\description{
A parametric version of the g function following Richards (1959):
\deqn{g(v) = M + \frac{1}{B} \log\left(\frac{Tv^T}{1-v^T}\right)}
}
\details{
The generalized logistic functions maps from (0,1) to \eqn{(-\infty,\infty)}.
\code{B} is the slope of the curve,  \code{T} is the symmetry and \code{M} is the offset.
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\references{
Richards, F. (1959). A flexible growth function for empirical use,
\emph{Journal of Experimental Botany}, 10, 290-301.
}
\seealso{
\code{\link{dg_glf}}, \code{\link{g_glf_inv}}
}
\keyword{Richards,}
\keyword{function.}
\keyword{generalized}
\keyword{logistic}

