% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{vcov.ocm}
\alias{vcov.ocm}
\title{Variance-Covariance Matrix for a Fitted Model Object}
\usage{
\method{vcov}{ocm}(object, ...)
}
\arguments{
\item{object}{an \code{ocm} object}

\item{...}{further arguments to be passed to methods}
}
\value{
Variance-covariance matrix of model parameters
}
\description{
Calculates variance-covariance matrix for a fitted \code{ocm} object
}
\details{
For the generalized logistic g-function, the variance-covariance matrix of model
parameters is
of dimension (\code{len_beta} +3)x(\code{len_beta} +3), where \code{len_beta}  is the number
of beta coefficients in the model.
}
\examples{
ANZ0001.ocm <- ANZ0001[ANZ0001$cycleno==0 | ANZ0001$cycleno==5,]
ANZ0001.ocm$cycleno[ANZ0001.ocm$cycleno==5] <- 1
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
vcov(fit.overall)
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\seealso{
\code{\link{ocm}}
}

