% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ordfor.R
\name{predict.ordfor}
\alias{predict.ordfor}
\title{Prediction using ordinal forest objects}
\usage{
\method{predict}{ordfor}(object, newdata, ...)
}
\arguments{
\item{object}{object of class \code{ordfor}. See function \code{\link{ordfor}}.}

\item{newdata}{data.frame. Data frame containing new data.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{predict.ordfor} returns an object of class \code{ordforpred}.
An object of class "\code{ordforpred}" is a list containing the following components: 
\item{ypred}{ vector of length \code{nrow(newdata)}. Factor-valued test data predictions. }
\item{yforestpredmetric}{ vector of length \code{nrow(newdata)}. Numeric test data predictions: Result of applying the regression forest \code{forestfinal} returned by \code{\link{ordfor}}. }
}
\description{
Prediction of test data using ordinal forest.
}
\examples{
data(hearth)

set.seed(123)
trainind <- sort(sample(1:nrow(hearth), size=floor(nrow(hearth)*(1/2))))
testind <- setdiff(1:nrow(hearth), trainind)

datatrain <- hearth[trainind,]
datatest <- hearth[testind,]

ordforres <- ordfor(depvar="Class", data=datatrain, ndiv=80, nbest=5)
# NOTE: ndiv=80 is not enough!! In practice, ndiv=1000 (default value) or a higher
# number should be used.

preds <- predict(ordforres, newdata=datatest)
preds
 
table(data.frame(true_values=datatest$Class, predictions=preds$ypred))

par(mfrow=c(1,2)) 
plot(preds$yforestpredmetric, as.numeric(preds$ypred))
plot(pnorm(preds$yforestpredmetric), as.numeric(preds$ypred), xlim=c(0,1))
par(mfrow=c(1,1))

}

