\name{orloca.es-package}
\alias{orloca.es-package}
\alias{orloca-package}
\alias{orloca}
\alias{orloca.es}
\docType{package}
\encoding{UTF-8}

\title{
  Spanish version of orloca package - Version espanola del paquete orloca}
\description{
  El paquete ofrece modelos de \enc{Análisis}{Analisis} de \enc{Localización}{Localizacion}.
  Esta \enc{versión}{version} aborda problemas de \enc{localización}{localizacion} min-sum. 
 El problema min-sum, \enc{también}{tambien} conocido como problema de Weber, localiza un punto tal que la suma ponderada de las distancias entre dicho punto y los puntos de demanda sea \enc{mínima}{minima}.
}
\details{
\preformatted{
Package:   orloca.es
Type:      Package
Version:   1.0
Date:      2008-07-03
License:   GPL (>= 2)
}
El paquete proporciona una clase (\code{loca.p}) que representa un problema de \enc{localización}{localizacion} con un conjunto finito de puntos de demanda sobre el plano. \enc{También}{Tambien} es posible representar los puntos y la \enc{función}{funcion} objetivo. Dicha \enc{función}{funcion} objetivo representa la suma de los desplazamientos de los usuarios a un servicio.

Para una demostración, cargue el paquete con \code{library(orloca.es)} y use \code{demo(orloca)}.
}
\author{
Fernando Fernandez-Palacin <fernando.fernandez@uca.es> and Manuel
 Munoz-Marquez <manuel.munoz@uca.es>
 
Maintainer: Manuel Munoz-Marquez <manuel.munoz@uca.es>
}
\references{
[1] Love, R. F., Morris, J. G., Wesolowsky, G. O. \emph{Facilities Location: Chapter 2: Introduction to Single-Facility Location}, 1988, North-Holland

[2] \url{http://knuth.uca.es/orloca}
}
\keyword{package}
\keyword{optimize}

\section{Index:}{
  \tabular{ll}{
\code{\link[orloca]{loca.p}}: \tab descripción de la clase loca.p.\cr
\code{\link[orloca]{rloca.p}}: \tab instancias aleatorias de objetos de la clase \code{loca.p}.\cr
\code{\link[orloca]{zsum}}: \tab función para evaluar la función objetivo para modelos min-sum.\cr
\code{\link[orloca]{zsummin}}: \tab para encontrar el mínimo del problema de localización.\cr
\code{\link[orloca]{plot.loca.p}}: \tab para hacer gráficos de los objetos de la clase \code{loca.p}.\cr
\code{\link[orloca]{plot.zsum}}: \tab para hacer gráficos de la función objetivo.\cr
}
}

\seealso{This is the spanish version of the orloca package. More information at \url{http://knuth.uca.es/orloca}}

\examples{
# Un objeto loca.p no ponderado
o <- new("loca.p", x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))

# Calcula la función objetivo en el punto c(3, 4)
zsum(o, 3, 4)

# Resuelve el problema de localización
zsummin(o)

# Curvas de nivel
contour(o)

# Ejecuta una demo del paquete
demo(orloca)
}
