% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zsum.R
\docType{methods}
\name{zsum}
\alias{zsum}
\alias{zsum,loca.p-method}
\title{Computes zsum function}
\usage{
zsum(o, x = 0, y = 0, lp = numeric(0))
}
\arguments{
\item{o}{An object of \code{loca.p} class.}

\item{x}{The x coordinate of the point to be evaluated.}

\item{y}{The y coordinate of the point to be evaluated.}

\item{lp}{If given, then \eqn{l_p} norm will be used instead of the Euclidean norm.}
}
\value{
\code{zsum} returns the objective function of the min-sum location problem, \eqn{\sum_{a_i \in o} w_i d(a_i, (x,y))}, where \eqn{d(a_i, (x,y))} gives the euclidean or the \eqn{l_p} distances between \eqn{a_i} and the point \eqn{(x,y)}.
}
\description{
The objective function and the gradient function for the min-sum location problem.
}
\examples{
# A new unweighted loca.p object
loca <- loca.p(x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))
# Evaluation of zsum at (0, 0)
zsum(loca)

# Evaluation of zsum at (1, 3)
zsum(loca, 1, 3)
# Compute the objective function at point (3, 4) using lp norm and p = 2.5
zsum(loca, 3, 4, lp=2.5)
# The gradient function at (1,3)
zsumgra(loca, 1, 3)

}
\seealso{
See also \code{\link{orloca-package}} and \code{\link{zsummin}}.
}
\keyword{classes}
\keyword{optimize}
