% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distsum.R
\docType{methods}
\name{distsum}
\alias{distsum}
\alias{distsum,loca.p-method}
\title{Computes distsum function}
\usage{
distsum(o, x = 0, y = 0, lp = numeric(0))
}
\arguments{
\item{o}{An object of \code{loca.p} class.}

\item{x}{The x coordinate of the point to be evaluated.}

\item{y}{The y coordinate of the point to be evaluated.}

\item{lp}{If given, then \eqn{l_p} norm will be used instead of the Euclidean norm.}
}
\value{
\code{distsum} returns the objective function of the min-sum location problem, \eqn{\sum_{a_i \in o} w_i d(a_i, (x,y))}, where \eqn{d(a_i, (x,y))} gives the euclidean or the \eqn{l_p} distances between \eqn{a_i} and the point \eqn{(x,y)}.
}
\description{
The objective function and the gradient function for the min-sum location problem.
}
\details{
The function zsum is deprecated and will be removed from new versions of the package.
}
\examples{
# A new unweighted loca.p object
loca <- loca.p(x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))
# Evaluation of distsum at (0, 0)
distsum(loca)

# Evaluation of distsum at (1, 3)
distsum(loca, 1, 3)
# Compute the objective function at point (3, 4) using lp norm and p = 2.5
distsum(loca, 3, 4, lp=2.5)
# The gradient function at (1,3)
distsumgra(loca, 1, 3)

}
\seealso{
See also \code{\link{orloca-package}} and \code{\link{distsummin}}.
}
\keyword{classes}
\keyword{optimize}
