% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/header.R
\name{extractHeader}
\alias{extractHeader}
\title{Extract Single Field from DICOM Headers}
\usage{
extractHeader(hdrs, string, numeric = TRUE, names = FALSE,
  inSequence = TRUE)
}
\arguments{
\item{hdrs}{List object of DICOM headers.}

\item{string}{DICOM field name.}

\item{numeric}{Logical; values are converted to numbers when \code{TRUE}.}

\item{names}{Logical; file names are kept with elements of the vector.}

\item{inSequence}{Logical; whether or not to look into SequenceItem
elements.}
}
\value{
Vector of values from the requested DICOM field.
}
\description{
A particular DICOM field is extracted for a collection of DICOM headers.
}
\details{
The DICOM field is extracted from each DICOM header and placed into a
vector.
}
\examples{
x <- readDICOMFile(system.file("dcm/Abdo.dcm", package="oro.dicom"))
seriesDescription <- extractHeader(x$hdr, "SeriesDescription", numeric=FALSE)
IOP <- extractHeader(x$hdr, "ImageOrientationPatient", numeric=FALSE)
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
Digital Imaging and Communications in Medicine (DICOM)\cr
\url{http://medical.nema.org}
}
\seealso{
\code{\link{readDICOM}}
}
\keyword{misc}

