% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qiba.R
\docType{methods}
\name{activityConcentration}
\alias{activityConcentration}
\alias{activityConcentration,array-method}
\alias{.activityConcentration}
\alias{standardUptakeValue}
\alias{standardUptakeValue,array-method}
\alias{.standardUptakeValue}
\title{Calculating SUVs for PET Using QIBA Pseudocode}
\usage{
activityConcentration(pixelData, ...)

\S4method{activityConcentration}{array}(pixelData, CSV = NULL,
  seriesNumber = NULL, method = "qiba")

.activityConcentration(pixelData, CSV = NULL, seriesNumber = NULL,
  method = "qiba")

standardUptakeValue(pixelData, ...)

\S4method{standardUptakeValue}{array}(pixelData, mask = NULL, CSV = NULL,
  seriesNumber = NULL, method = c("qiba", "user"), prior = NULL,
  decayedDose = NULL)

.standardUptakeValue(pixelData, mask = NULL, CSV = NULL,
  seriesNumber = NULL, method = c("qiba", "user"), prior = NULL,
  decayedDose = NULL)
}
\arguments{
\item{pixelData}{is a multidimensional array of signal intensities of class
\code{nifti}.}

\item{...}{additional arguments}

\item{CSV}{is a \code{data.frame} that is the output from \code{dicomTable}
and contains all necessary DICOM header fields.}

\item{seriesNumber}{is the SeriesNumber that corresponds to the PET
acquisition.}

\item{method}{takes on two possible values (\code{qiba} and \code{user}),
where QIBA pseudocode is used to calculate the SUVs or user-defined
parameters are used.}

\item{mask}{is a multidimensional array of logical values (only used when
\code{method = "user"}).}

\item{prior}{is a list of DICOM header field names that are necessary for
the SUV calculation under \code{method = "user"} or may be used to replace
values from the DICOM header information when \code{method = "qiba"}.}

\item{decayedDose}{is the amount of the RadionuclideTotalDose after being
corrected for residual dose in the syringe.  This value is NOT usually
corrected in the DICOM data.}
}
\value{
A list containing the following items 
\itemize{
\item{SUVbw}{is a
multidimensional array, the same dimension as \code{pixelData}, that
contains the standard uptake values.} 
\item{hdr}{is a list of DICOM header
fields used in the SUV calculation.} 
\item{decayTime}{is the decay time
calculated from the DICOM header information.} 
\item{decayedDose}{is the
RadionuclideTotalDose, if taken from the DICOM header information, or the
user-specified value.} 
\item{SUVbwScaleFactor}{is
\eqn{\mbox{PatientsWeight}\cdot1000/\mbox{decayedDose}}.
}
}
}
\description{
The standard uptake value (SUV) is calculated based on an 18F-FDG-PET
acquisition using ancillary information contained in the DICOM data.
}
\note{
Note, for GE scanners it is common for the RescaleSlope DICOM field to vary
on a slice-by-slice basis.  This is taken into account if a GE scanner is
detected from the Modality DICOM field.  However, the InstanceNumber is used
to reorder the slices so they match the incoming NIfTI file of PixelData.
If this is not correct it may be necessary to manually re-order the
RescaleSlope field in the CSV data frame so that the activity concentration
is calculated correctly.
}
\references{
\url{http://qibawiki.rsna.org/index.php?title=Standardized_Uptake_Value_(SUV)}
}
\seealso{
\code{\link[oro.dicom]{dicomTable}}, \code{\link[oro.nifti]{nifti}}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
