#' @title skcm.clinical
#' @name skcm.clinical
#' @description The clinical varaibles of the SKCM dataset. The original data was obtained from The Cancer Genome Atlas (TCGA).
#' @usage skcm.clinical
#' @docType data
#' @format Contains 469 subjects with 156 failured. Each row contains one subject, subject ID is indicated by row name. Variables include \code{Time}, \code{Censor}, \code{Gender} and \code{Age}. \code{Age} has 8 missing values.
#' @references \url{https://cancergenome.nih.gov/}
#' @keywords skcm.clinical
NULL

#' @title skcm.melgene
#' @name skcm.melgene
#' @description The expression of top 20 genes of cutaneous melanoma literature based on Athanasiadis, et al. 2014.
#' @usage skcm.melgene
#' @docType data
#' @format Each row contains one subject, subject ID is indicated by row name. Gene names in the columns. The columns are scaled.
#' @references Athanasiadis, Emmanouil I., et al. "A Web-based database of genetic association studies in cutaneous melanoma enhanced with network-driven data exploration tools." Database 2014 (2014).
#' @keywords skcm.melgene
NULL

