% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{oscar.sparsify}
\alias{oscar.sparsify}
\title{Create a sparse matrix representation of betas as a function of k}
\usage{
oscar.sparsify(fit, kmax = fit@kmax)
}
\arguments{
\item{fit}{oscar-model object}

\item{kmax}{Create matrix until kmax-value; by default same as for fit object, but for high dimensional tasks one may wish to reduce this}
}
\value{
A sparse matrix of variables (rows) as a function of cardinality k (columns), where elements are the beta estimates.
}
\description{
Variable estimates (rows) as a function of cardinality (k, columns). Since a model can drop out variables in favor of two better ones as k increases, this sparse representation helps visualize which variables are included at what cardinality.
}
\details{
Uses sparseMatrix-class from Matrix-package
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  oscar.sparsify(fit, kmax=5)
}

}
