% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visu.R
\name{oscar.cv.visu}
\alias{oscar.cv.visu}
\title{Visualize cross-validation as a function of k}
\usage{
oscar.cv.visu(
  cv,
  add = FALSE,
  main = "OSCAR cross-validation",
  xlab = "Cardinality 'k'",
  ylab = "CV performance",
  ...
)
}
\arguments{
\item{cv}{Matrix produced by oscar.cv; rows are cv-folds, cols are k-values}

\item{add}{Should plot be added on top of an existing plot device}

\item{main}{Main title}

\item{xlab}{X-axis label}

\item{ylab}{Y-axis label}

\item{...}{Additional parameters passed on top the CV points}
}
\value{
This is a plotting function that does not return anything, but instead draws on an existing or a new graphics device.
}
\description{
This function plots the model performance as a function of cardinality for k-fold cross-validation. Performance metric depends on user choice and model family (i.e. lower MSE is good, higher C-index is good).
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  fit_cv <- oscar.cv(fit, fold = 10, seed = 123)
  oscar.cv.visu(fit_cv)
}
}
