% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{extract_id}
\alias{extract_id}
\alias{extract_keywords}
\alias{extract_name}
\alias{extract_superseded}
\alias{extractors}
\title{Extract components from OSI metadata}
\usage{
extract_id(metadata)

extract_name(metadata)

extract_superseded(metadata)

extract_keywords(metadata)
}
\arguments{
\item{metadata}{a metadata object returned from \code{\link{license_by_keyword}},
\code{\link{license_by_id}} or \code{\link{license_list}}.}
}
\value{
a vector of the appropriate metadata element for each entry
(or a list of vectors in the case of \code{extract_keywords}, since
there can be multiple keywords per license).
}
\description{
Elements of the metadata returned from other functions - such as
\code{\link{license_list}} or \code{\link{license_by_keyword}} - can be
extracted from the overarching metadata using this collection of functions,
which (respectively) pull out the license ID, license name,
what superseded the license, and what keywords the license has.
}
\examples{

#Get the names of all licenses
all_license_metadata <- license_list()
license_names <- extract_name(all_license_metadata)
}

