% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getbb.R
\name{getbb}
\alias{getbb}
\title{Get bounding box for a given place name}
\usage{
getbb(place_name, display_name_contains = NULL, viewbox = NULL,
  format_out = "matrix",
  base_url = "https://nominatim.openstreetmap.org",
  featuretype = "settlement", limit = 10, key = NULL,
  silent = TRUE, poly_num = c(1, 1))
}
\arguments{
\item{place_name}{The name of the place you're searching for}

\item{display_name_contains}{Text string to match with display_name field
returned by \url{http://wiki.openstreetmap.org/wiki/Nominatim}}

\item{viewbox}{The bounds in which you're searching}

\item{format_out}{Character string indicating output format: matrix (default),
string (see \code{\link[=bbox_to_string]{bbox_to_string()}}), data.frame (all 'hits' returned
by Nominatim), sf_polygon (for polygons that work with the sf package)
or polygon (full polygonal bounding boxes for each match).}

\item{base_url}{Base website from where data is queried}

\item{featuretype}{The type of OSM feature (settlement is default; see Note)}

\item{limit}{How many results should the API return?}

\item{key}{The API key to use for services that require it}

\item{silent}{Should the API be printed to screen? TRUE by default}

\item{poly_num}{Which of matching polygons should be used?
The first polygon in the first match is the default (\code{c(1, 1)}).}
}
\value{
Unless \code{format_out = "polygon"}, a numeric bounding box as min
and max of latitude and longitude. If \code{format_out = "polygon"}, one or
more two-columns matrices of polygonal longitude-latitude points. Where
multiple \code{place_name} occurrences are found within \code{nominatim},
each item of the list of coordinates may itself contain multiple coordinate
matrices where multiple exact matches exist. If one one exact match exists
with potentially multiple polygonal boundaries (for example, "london uk" is
an exact match, but can mean either greater London or the City of London),
only the first is returned. See examples below for illustration.
}
\description{
This function uses the free Nominatim API provided by OpenStreetMap to find
the bounding box (bb) associated with place names.
}
\details{
It was inspired by the functions
\code{bbox} from the \pkg{sp} package,
\code{bb} from the \pkg{tmaptools} package and
\code{bb_lookup} from the github package \pkg{nominatim} package,
which can be found at \url{https://github.com/hrbrmstr/nominatim}.

See \url{http://wiki.openstreetmap.org/wiki/Nominatim} for details.
}
\note{
Specific values of \code{featuretype} include "street", "city",
\url{http://wiki.openstreetmap.org/wiki/Nominatim} for details). The default
\code{featuretype = "settlement"} combines results from all intermediate
levels below "country" and above "streets". If the bounding box or polygon of
a city is desired, better results will usually be obtained with
\code{featuretype = "city"}.
}
\examples{
\dontrun{
getbb("Salzburg")
# select based on display_name, print query url
getbb("Hereford", display_name_contains = "United States", silent = FALSE)
# top 3 matches as data frame
getbb("Hereford", format_out = "data.frame", limit = 3)
# Examples of polygonal boundaries
bb <- getbb ("london uk", format_out = "polygon") # single match
dim(bb[[1]]) # matrix of longitude/latitude pairs
bb_sf = getbb("kathmandu", format_out = "sf_polygon") 
# sf:::plot.sf(bb_sf) # can be plotted if sf is installed
getbb("london", format_out = "sf_polygon") # only selects 1st of multipolygons
getbb("accra", format_out = "sf_polygon") # rectangular bb
# Using an alternative service (locationiq requires an API key)
key <- Sys.getenv("LOCATIONIQ") # add LOCATIONIQ=type_your_api_key_here to .Renviron
if(nchar(key) ==  32) {
  getbb(place_name, base_url = "http://locationiq.org/v1/search.php", key = key)
}
}
}
