% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{oe_match_pattern}
\alias{oe_match_pattern}
\title{Check patterns in the provider's databases}
\usage{
oe_match_pattern(pattern, match_by = "name", full_row = FALSE)
}
\arguments{
\item{pattern}{Character string representing the pattern that should be
explored.}

\item{match_by}{Column name of the provider's database that will be used to
find the match.}

\item{full_row}{Boolean. Return all columns for the matching rows? \code{FALSE} by
default.}
}
\value{
A list of character vectors or \code{sf} objects (according to the value
of the parameter \code{full_row}). If no OSM zone can be matched with the input
string, then the function returns an empty list.
}
\description{
This function is used to explore the provider's databases and look for
patterns. This function can be useful in combination with \code{\link[=oe_match]{oe_match()}} and
\code{\link[=oe_get]{oe_get()}} for an easy match. See Examples.
}
\examples{
oe_match_pattern("Yorkshire")

res = oe_match_pattern("Yorkshire", full_row = TRUE)
lapply(res, function(x) sf::st_drop_geometry(x)[, 1:3])

oe_match_pattern("ABC")
oe_match_pattern("Yorkshire", match_by = "ABC")
}
