% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{geofabrik_zones}
\alias{geofabrik_zones}
\title{An sf object of geographical zones taken from geofabrik.de}
\format{
An sf object with 475 rows and
9 columns:
\describe{
\item{id}{A unique identifier. It contains letters, numbers and potentially
the characters "-" and "/".}
\item{name}{The, usually English, long-form name of the area.}
\item{parent}{The identifier of the next larger excerpts that contains this
one, if present.}
\item{level}{An integer code between 1 and 4. If level = 1, then the zone
corresponds to one of the continents (Africa, Antarctica, Asia, Australia
and Oceania, Central America, Europe, North America, and South America) or
the Russian Federation. If level = 2, then the zone corresponds to the
continent's subregions (i.e. the countries such as Italy, Great Britain,
Spain, USA, Mexico, Belize, Morocco, Peru and so on). There are also some
exceptions that correspond to the Special Sub Regions (according to the
Geofabrik definition), which are: South Africa (includes Lesotho), Alps,
Britain and Ireland, Germany + Austria + Switzerland, US Midwest, US
Northeast, US Pacific, US South, US West, and all US states. Level = 3L
corresponds to the subregions of each state (or each level 2 zone). For
example, the West Yorkshire, which is a subregion of England, is a level 3
zone. Finally, level = 4 correspond to the subregions of the third level
and it is mainly related to some small areas in Germany. This field is used
only for matching operations in case of spatial input.}
\item{iso3166-1_alpha2}{A character vector of two-letter \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO3166-1 codes}. This will be set
on the smallest extract that still fully (or mostly) contains the entity
with that code; e.g. the code "DE" will be given for the Germany extract
and not for Europe even though Europe contains Germany. If an extract
covers several countries and no per-country extracts are available (e.g.
Israel and Palestine), then several ISO codes will be given (such as "PS
IL" for "Palestine and Israel").}
\item{iso3166_2}{A character vector of usually five-character \href{https://en.wikipedia.org/wiki/ISO_3166-2}{ISO3166-2 codes}. The same rules as above
apply. Some entities have both an \emph{iso3166-1} and \emph{iso3166-2} code. For
example, the \emph{iso3166_2} code of each US State is "US - " plus the code of
the state.}
\item{pbf}{Link to the latest \code{.osm.pbf} file for this region.}
\item{pbf_file_size}{Size of the \code{.pbf} file in bytes.}
\item{geometry}{The \code{sfg} for that geographical region. These are not the
country boundaries, but a buffer around countries. Check
\code{oe_get_boundary()} to extract the geographical boundaries.}
}
}
\source{
\url{https://download.geofabrik.de/}
}
\usage{
geofabrik_zones
}
\description{
An \code{sf} object containing the URLs, names and file-sizes of the OSM
extracts stored at \url{https://download.geofabrik.de/}. You can read more
details about these data at the following link:
\url{https://download.geofabrik.de/technical.html}.
}
\seealso{
Other provider's-database: 
\code{\link{bbbike_zones}},
\code{\link{openstreetmap_fr_zones}}
}
\concept{provider's-database}
\keyword{datasets}
