/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality.additional;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.mortality.AbstractMortalitySpecies;
import fr.ird.osmose.util.timeseries.ByClassTimeSeries;

public class ByDtByClassAdditionalMortality
extends AbstractMortalitySpecies {
    private double[][] m;
    private float[] sizeClasses;
    private int[] ageClasses;

    public ByDtByClassAdditionalMortality(int rank, Species species) {
        super(rank, species);
    }

    @Override
    public void init() {
        int iSpec = this.getIndexSpecies();
        if (!this.getConfiguration().isNull("mortality.natural.rate.byDt.byAge.file.sp" + iSpec)) {
            ByClassTimeSeries timeSerieByAge = new ByClassTimeSeries(this.getRank());
            timeSerieByAge.read(this.getConfiguration().getFile("mortality.natural.rate.byDt.byAge.file.sp" + iSpec));
            this.m = timeSerieByAge.getValues();
            this.ageClasses = new int[timeSerieByAge.getNClass() - 1];
            for (int k = 0; k < this.ageClasses.length; ++k) {
                this.ageClasses[k] = Math.round(timeSerieByAge.getClass(k) * (float)this.getConfiguration().getNStepYear());
            }
        } else if (!this.getConfiguration().isNull("mortality.natural.rate.byDt.bySize.file.sp" + iSpec)) {
            ByClassTimeSeries timeSerieBySize = new ByClassTimeSeries(this.getRank());
            timeSerieBySize.read(this.getConfiguration().getFile("mortality.natural.rate.byDt.bySize.file.sp" + iSpec));
            this.m = timeSerieBySize.getValues();
            this.sizeClasses = timeSerieBySize.getClasses();
        } else {
            this.getSimulation().error("Could not found parameters mortality.natural.rate.byDt.byAge/bySize.file.sp" + iSpec, null);
        }
    }

    @Override
    public double getRate(School school) {
        int iSimu = this.getSimulation().getIndexTimeSimu();
        if (null != this.sizeClasses) {
            float length = school.getLength();
            if (length < this.sizeClasses[0]) {
                return 0.0;
            }
            for (int k = 0; k < this.sizeClasses.length - 1; ++k) {
                if (!(this.sizeClasses[k] <= length) || !(length < this.sizeClasses[k + 1])) continue;
                return this.m[iSimu][k];
            }
            return this.m[iSimu][this.sizeClasses.length - 1];
        }
        if (null != this.ageClasses) {
            float age = school.getAgeDt();
            if (age < (float)this.ageClasses[0]) {
                return 0.0;
            }
            for (int k = 0; k < this.ageClasses.length - 1; ++k) {
                if (!((float)this.ageClasses[k] <= age) || !(age < (float)this.ageClasses[k + 1])) continue;
                return this.m[iSimu][k];
            }
            return this.m[iSimu][this.ageClasses.length - 1];
        }
        return Double.NaN;
    }
}

