/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util;

import au.com.bytecode.opencsv.CSVReader;
import fr.ird.osmose.Cell;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.util.Separator;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class GridMap {
    private final float[][] matrix = new float[GridMap.getOsmose().getGrid().get_ny()][GridMap.getOsmose().getGrid().get_nx()];

    public GridMap(int defaultValue) {
        for (Cell cell : GridMap.getOsmose().getGrid().getCells()) {
            if (cell.isLand()) {
                this.matrix[cell.get_jgrid()][cell.get_igrid()] = -99.0f;
                continue;
            }
            this.matrix[cell.get_jgrid()][cell.get_igrid()] = defaultValue;
        }
    }

    public GridMap() {
        this(0);
    }

    public GridMap(String csvFile) {
        this();
        this.read(csvFile);
    }

    private void read(String csvFile) {
        try {
            CSVReader reader = new CSVReader(new FileReader(csvFile), Separator.guess(csvFile).getSeparator());
            List<String[]> lines = reader.readAll();
            int ny = GridMap.getOsmose().getGrid().get_ny();
            for (int l = 0; l < lines.size(); ++l) {
                String[] line = lines.get(l);
                int j = ny - l - 1;
                for (int i = 0; i < line.length; ++i) {
                    try {
                        float value = Float.valueOf(line[i]).floatValue();
                        if (!(value > 0.0f)) continue;
                        this.matrix[j][i] = value;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        GridMap.getOsmose().error("Error parsing CSV map " + csvFile + " row " + (l + 1) + " column " + (i + 1), ex);
                    }
                }
            }
            reader.close();
        }
        catch (IOException ex) {
            GridMap.getOsmose().error("Error reading CSV map " + csvFile, ex);
        }
    }

    public void setValue(int i, int j, float value) {
        this.matrix[j][i] = value;
    }

    public float getValue(int i, int j) {
        return this.matrix[j][i];
    }

    public void setValue(Cell cell, float value) {
        this.setValue(cell.get_igrid(), cell.get_jgrid(), value);
    }

    public float getValue(Cell cell) {
        return this.getValue(cell.get_igrid(), cell.get_jgrid());
    }

    public static Osmose getOsmose() {
        return Osmose.getInstance();
    }
}

