/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractMeanDistribOutput;
import fr.ird.osmose.output.distribution.AbstractDistribution;
import java.io.File;

public class MeanSizeDistribOutput
extends AbstractMeanDistribOutput {
    public MeanSizeDistribOutput(int rank, AbstractDistribution distrib) {
        super(rank, distrib);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getType().toString());
        filename.append("Indicators");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_meanSizeDistribBy");
        filename.append(this.getType().toString());
        filename.append("_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append("Mean size of fish (centimeter) by ");
        description.append(this.getType().getDescription());
        description.append(". For class i, the mean size in [i,i+1[ is reported.");
        return description.toString();
    }

    @Override
    public void initStep() {
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int iSpec = school.getSpeciesIndex();
            int iClass = this.getClass(school);
            if (iClass < 0) continue;
            double[] dArray = this.values[iSpec];
            int n = iClass;
            dArray[n] = dArray[n] + school.getInstantaneousAbundance() * (double)school.getLength();
            double[] dArray2 = this.denominator[iSpec];
            int n2 = iClass;
            dArray2[n2] = dArray2[n2] + school.getInstantaneousAbundance();
        }
    }
}

