/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.movement;

import fr.ird.osmose.Cell;
import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.movement.AbstractDistribution;
import fr.ird.osmose.util.GridMap;
import fr.ird.osmose.util.MapSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class MapDistribution
extends AbstractDistribution {
    private final Species species;
    private Random rd1;
    private Random rd2;
    private Random rd3;
    private MapSet maps;
    private float[] maxProbaPresence;
    private int range;

    public MapDistribution(int rank, Species species) {
        super(rank);
        this.species = species;
    }

    @Override
    public void init() {
        int iSpec = this.species.getIndex();
        boolean fixedSeed = false;
        if (!this.getConfiguration().isNull("movement.randomseed.fixed")) {
            fixedSeed = this.getConfiguration().getBoolean("movement.randomseed.fixed");
        }
        if (fixedSeed) {
            this.rd1 = new Random(0xDL ^ (long)iSpec);
            this.rd2 = new Random(5L ^ (long)iSpec);
            this.rd3 = new Random(0x7BEL ^ (long)iSpec);
            this.warning("Parameter 'movement.randomseed.fixed' is set to true. It means that two simulations with strictly identical initial school distribution will lead to same movement.");
        } else {
            this.rd1 = new Random();
            this.rd2 = new Random();
            this.rd3 = new Random();
        }
        this.maps = new MapSet(this.getRank(), iSpec, "movement");
        this.maps.init();
        this.maxProbaPresence = new float[this.maps.getNMap()];
        for (int imap = 0; imap < this.maxProbaPresence.length; ++imap) {
            this.maxProbaPresence[imap] = this.computeMaxProbaPresence(imap);
            if (!(this.maxProbaPresence[imap] >= 1.0f)) continue;
            this.maxProbaPresence[imap] = 0.0f;
        }
        this.range = !this.getConfiguration().isNull("movement.randomwalk.range.sp" + iSpec) ? this.getConfiguration().getInt("movement.randomwalk.range.sp" + iSpec) : 1;
    }

    @Override
    public void move(School school) {
        if (!this.isOut(school)) {
            this.mapsDistribution(school);
        } else {
            school.out();
        }
    }

    private boolean isOut(School school) {
        return null == this.maps.getMap(school);
    }

    private void mapsDistribution(School school) {
        int oldTime;
        int previousIndexMap;
        int i_step_year = this.getSimulation().getIndexTimeYear();
        int age = school.getAgeDt();
        int indexMap = this.maps.getIndexMap(school);
        GridMap map = this.maps.getMap(indexMap);
        boolean sameMap = false;
        if (age > 0 && this.getSimulation().getIndexTimeSimu() > 0 && indexMap == (previousIndexMap = this.maps.getIndexMap(age - 1, oldTime = i_step_year == 0 ? this.getConfiguration().getNStepYear() - 1 : i_step_year - 1))) {
            sameMap = true;
        }
        if (!sameMap || school.isUnlocated()) {
            int indexCell;
            double proba;
            int nCells = this.getGrid().get_nx() * this.getGrid().get_ny();
            do {
                indexCell = (int)Math.round((double)(nCells - 1) * this.rd1.nextDouble());
            } while ((proba = (double)map.getValue(this.getGrid().getCell(indexCell))) <= 0.0 || proba < this.rd2.nextDouble() * (double)this.maxProbaPresence[indexMap]);
            school.moveToCell(this.getGrid().getCell(indexCell));
        } else {
            school.moveToCell(this.randomDeal(this.getAccessibleCells(school, map), this.rd3));
        }
    }

    private List<Cell> getAccessibleCells(School school, GridMap map) {
        Cell cell = school.getCell();
        if ((double)map.getValue(cell) <= 0.0) {
            StringBuilder str = new StringBuilder("Inconsistency in moving ");
            str.append(school.toString());
            str.append("\n");
            str.append("It is not in the geographical area it is supposed to be...");
            this.getSimulation().warning(str.toString());
        }
        ArrayList<Cell> accessibleCells = new ArrayList<Cell>();
        for (Cell neighbour : this.getGrid().getNeighbourCells(cell, this.range)) {
            if (neighbour.isLand() || !(map.getValue(neighbour) > 0.0f)) continue;
            accessibleCells.add(neighbour);
        }
        return accessibleCells;
    }

    private Cell randomDeal(List<Cell> cells, Random rd) {
        int index = (int)Math.round((double)(cells.size() - 1) * rd.nextDouble());
        return cells.get(index);
    }

    private float computeMaxProbaPresence(int numMap) {
        float tempMaxProbaPresence = 0.0f;
        GridMap map = this.maps.getMap(numMap);
        if (null != map) {
            for (int j = 0; j < this.getGrid().get_ny(); ++j) {
                for (int i = 0; i < this.getGrid().get_nx(); ++i) {
                    tempMaxProbaPresence = Math.max(tempMaxProbaPresence, map.getValue(i, j));
                }
            }
        }
        return tempMaxProbaPresence;
    }
}

