/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util;

import au.com.bytecode.opencsv.CSVReader;
import fr.ird.osmose.Cell;
import fr.ird.osmose.util.Separator;
import fr.ird.osmose.util.SimulationLinker;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MPA
extends SimulationLinker {
    private final int index;
    private List<Cell> cells;
    private int start;
    private int end;

    public MPA(int rank, int index) {
        super(rank);
        this.index = index;
    }

    public void init() {
        this.cells = new ArrayList<Cell>();
        if (!this.getConfiguration().isNull("mpa.file.mpa" + this.index)) {
            this.loadMPA(this.getConfiguration().getFile("mpa.file.mpa" + this.index));
            this.start = this.getConfiguration().getInt("mpa.start.year.mpa" + this.index);
            this.end = this.getConfiguration().getInt("mpa.end.year.mpa" + this.index);
        } else {
            this.start = Integer.MAX_VALUE;
        }
    }

    public int getYearStart() {
        return this.start;
    }

    public int getYearEnd() {
        return this.end;
    }

    public boolean isActive(int iStepSimu) {
        if (iStepSimu < 0) {
            return false;
        }
        int year = iStepSimu / this.getConfiguration().getNStepYear();
        return year >= this.start && year <= this.end;
    }

    public boolean contains(Cell cell) {
        return this.cells.contains(cell);
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    private void loadMPA(String csvFile) {
        try {
            CSVReader reader = new CSVReader(new FileReader(csvFile), Separator.guess(csvFile).getSeparator());
            List<String[]> lines = reader.readAll();
            int ny = this.getGrid().get_ny();
            for (int l = 0; l < lines.size(); ++l) {
                String[] line = lines.get(l);
                int j = ny - l - 1;
                for (int i = 0; i < line.length; ++i) {
                    float val = Float.valueOf(line[i]).floatValue();
                    if (!(val > 0.0f)) continue;
                    this.cells.add(this.getGrid().getCell(i, j));
                }
            }
        }
        catch (IOException ex) {
            this.error("Error loading MPA " + csvFile, ex);
        }
        catch (NumberFormatException ex) {
            this.error("Error loading MPA " + csvFile, ex);
        }
    }
}

