/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.timeseries;

import au.com.bytecode.opencsv.CSVReader;
import fr.ird.osmose.util.Separator;
import fr.ird.osmose.util.SimulationLinker;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class SingleTimeSeries
extends SimulationLinker {
    private double[] values;

    public SingleTimeSeries(int rank) {
        super(rank);
    }

    public void read(String filename) {
        int nStepYear = this.getConfiguration().getNStepYear();
        int nStepSimu = nStepYear * this.getConfiguration().getNYear();
        this.read(filename, nStepYear, nStepSimu);
    }

    public void read(String filename, int nMin, int nMax) {
        int nStepYear = this.getConfiguration().getNStepYear();
        int nStepSimu = nStepYear * this.getConfiguration().getNYear();
        try {
            int t;
            CSVReader reader = new CSVReader(new FileReader(filename), Separator.guess(filename).getSeparator());
            List<String[]> lines = reader.readAll();
            int nTimeSerie = lines.size() - 1;
            if (nTimeSerie < nMin) {
                throw new IOException("Found " + nTimeSerie + " time steps in the time serie. It must contain at least " + nMin + " time steps.");
            }
            if (nTimeSerie % nStepYear != 0) {
                throw new IOException("Found " + nTimeSerie + " time steps in the time serie. It must be a multiple of the number of time steps per year.");
            }
            if (nTimeSerie > nMax) {
                this.getSimulation().warning("Time serie in file {0} contains {1} steps out of {2}. Osmose will ignore the exceeding years.", new Object[]{filename, nTimeSerie, nMax});
            }
            nTimeSerie = Math.min(nTimeSerie, nMax);
            this.values = new double[nStepSimu];
            for (t = 0; t < nTimeSerie; ++t) {
                String[] line = lines.get(t + 1);
                this.values[t] = Double.valueOf(line[1]);
            }
            if (nTimeSerie < nStepSimu) {
                t = nTimeSerie;
                block3: while (t < nStepSimu) {
                    for (int k = 0; k < nTimeSerie; ++k) {
                        this.values[t] = this.values[k];
                        if (++t == nStepSimu) continue block3;
                    }
                }
                this.getSimulation().warning("Time serie in file {0} only contains {1} steps out of {2}. Osmose will loop over it.", new Object[]{filename, nTimeSerie, nStepSimu});
            }
        }
        catch (IOException ex) {
            this.getSimulation().error("Error reading CSV file " + filename, ex);
        }
    }

    public double[] getValues() {
        return this.values;
    }
}

