% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enum.R
\name{enum}
\alias{enum}
\title{Define an enumerated list}
\usage{
enum(enumValues)
}
\arguments{
\item{enumValues}{A vector or a list of comma-separated constants to use for
creating the enum. Optionally, these can be named constants.}
}
\value{
An enumerated list.
}
\description{
Create an enumeration to be used instead of arbitrary values in code. In some
languages (C, C++, Python, etc.), enum (or enumeration) is a data type that
consists of integer constants and is ideal in contexts where a variable can
take on only one of a limited set of possible values (e.g. day of the week).
Since R programming language natively doesn't support enumeration, the
current function provides a way to create them using lists.
}
\examples{
# Without predefined values
Color <- enum(c("Red", "Blue", "Green"))
Color
myColor <- Color$Red
myColor

# With predefined values
Symbol <- enum(c(Diamond = 1, Triangle = 2, Circle = 2))
Symbol

mySymbol <- Symbol$Diamond
mySymbol
}
\seealso{
Other enumeration-helpers: 
\code{\link{enumGetKey}()},
\code{\link{enumGetValue}()},
\code{\link{enumHasKey}()},
\code{\link{enumKeys}()},
\code{\link{enumPut}()},
\code{\link{enumRemove}()},
\code{\link{enumValues}()}
}
\concept{enumeration-helpers}
