% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmTable.R
\name{osrmTable}
\alias{osrmTable}
\title{Get Travel Time Matrices Between Points}
\usage{
osrmTable(loc, src = NULL, dst = NULL)
}
\arguments{
\item{loc}{a data frame containing 3 fields: points identifiers, longitudes 
and latitudes (WGS84). It can also be a SpatialPointsDataFrame or a 
SpatialPolygonsDataFrame, then row names are used as identifiers.
If loc parameter is used, all pair-wise distances are computed.}

\item{src}{a data frame containing origin points identifiers, longitudes 
and latitudes (WGS84). It can also be a SpatialPointsDataFrame or a 
SpatialPolygonsDataFrame, then row names are used as identifiers. 
If dst and src parameters are used, only pairs between scr/dst are computed.}

\item{dst}{a data frame containing destination points identifiers, longitudes 
and latitudes (WGS84). It can also be a SpatialPointsDataFrame or a 
SpatialPolygonsDataFrame, then row names are used as identifiers.}
}
\value{
A list containing 3 data frames is returned. 
durations is the matrix of travel times (in minutes), 
sources and destinations are the coordinates of 
the origin and destination points actually used to compute the travel 
times (WGS84).
}
\description{
Build and send OSRM API queries to get travel time matrices 
between points. This function interfaces the \emph{table} OSRM service.
}
\details{
If loc, src or dst are data frames we assume that the 3 first 
columns of the data.frame are: identifiers, longitudes and latitudes.
}
\note{
The public OSRM API does not allow more than 10 000 
distances in query result. \cr
If you use an other OSRM API service, make sure that 
more distances are allowed in results 
(i.e. the "max-table-size" argument, Max. locations supported in distance 
table query).
}
\examples{
\dontrun{
# Load data
data("com")

# Inputs are data frames  
# Travel time matrix
distCom <- osrmTable(loc = com[1:50, c("comm_id","lon","lat")])
# First 5 rows and columns
distCom$durations[1:5,1:5]

# Travel time matrix with different sets of origins and destinations
distCom2 <- osrmTable(src = com[1:10,c("comm_id","lon","lat")],
                      dst = com[11:20,c("comm_id","lon","lat")])
# First 5 rows and columns
distCom2$durations[1:5,1:5]


# Inputs are SpatialPointsDataFrames
distCom <- osrmTable(loc = src)
# First 5 rows and columns
distCom$durations[1:5,1:5]

# Travel time matrix with different sets of origins and destinations
distCom2 <- osrmTable(src = src, dst = dst)
# First 5 rows and columns
distCom2$durations[1:5,1:5]
}
}
\seealso{
\link{osrmIsochrone}
}

