% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{up_down_counter_add}
\alias{up_down_counter_add}
\title{Increase or decrease an OpenTelemetry up-down counter}
\usage{
up_down_counter_add(
  name,
  value = 1L,
  attributes = NULL,
  context = NULL,
  meter = NULL
)
}
\arguments{
\item{name}{Name of the up-down counter.}

\item{value}{Value to add to or subtract from the counter, defaults
to 1.}

\item{attributes}{Additional attributes to add.}

\item{context}{Span context. If missing the active context is used,
if any.}

\item{meter}{Meter object (\link{otel_meter}). Otherwise it is passed to
\code{\link[=get_meter]{get_meter()}} to get a meter.}
}
\value{
The up-down counter object (\link{otel_up_down_counter}), invisibly.
}
\description{
Increase or decrease an OpenTelemetry up-down counter
}
\examples{
otel::up_down_counter_add("session-count", 1)
}
\seealso{
Other OpenTelemetry metrics instruments: 
\code{\link{counter_add}()},
\code{\link{gauge_record}()},
\code{\link{histogram_record}()}

Other OpenTelemetry metrics API: 
\code{\link{counter_add}()},
\code{\link{gauge_record}()},
\code{\link{histogram_record}()},
\code{\link{is_measuring_enabled}()}
}
\concept{OpenTelemetry metrics API}
\concept{OpenTelemetry metrics instruments}
