% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp_get_times.R
\name{otp_get_times}
\alias{otp_get_times}
\title{Queries OTP for the time or detailed itinerary for a trip between an origin
and destination}
\usage{
otp_get_times(
  otpcon,
  fromPlace,
  toPlace,
  mode = "CAR",
  date = format(Sys.Date(), "\%m-\%d-\%Y"),
  time = format(Sys.time(), "\%H:\%M:\%S"),
  maxWalkDistance = NULL,
  walkReluctance = 2,
  waitReluctance = 1,
  arriveBy = FALSE,
  transferPenalty = 0,
  minTransferTime = 0,
  maxItineraries = 1,
  detail = FALSE,
  includeLegs = FALSE,
  extra.params = list()
)
}
\arguments{
\item{otpcon}{An OTP connection object produced by \code{\link{otp_connect}}.}

\item{fromPlace}{Numeric vector, Latitude/Longitude pair, e.g. `c(53.48805, -2.24258)`}

\item{toPlace}{Numeric vector, Latitude/Longitude pair, e.g. `c(53.36484, -2.27108)`}

\item{mode}{Character vector, mode(s) of travel. Valid values are: WALK, BICYCLE,
CAR, TRANSIT, BUS, RAIL, TRAM, SUBWAY OR 'c("TRANSIT", "BICYCLE")'. TRANSIT will use all
available transit modes. Default is CAR. WALK mode is automatically
added for TRANSIT, BUS, RAIL, TRAM, and SUBWAY.}

\item{date}{Character, must be in the format mm-dd-yyyy. This is the desired date of travel.
Only relevant for transit modes. Default is the current system date.}

\item{time}{Character, must be in the format hh:mm:ss.
If \code{arriveBy} is FALSE (the default) this is the desired departure time, otherwise the
desired arrival time. Only relevant for transit modes. Default is the current system time.}

\item{maxWalkDistance}{Numeric. The maximum distance (in meters) that the user is
willing to walk. Default is NULL (the parameter is not passed to the API and the OTP
default of unlimited takes effect).
This is a soft limit in OTPv1 and is ignored if the mode is WALK only. In OTPv2
this parameter imposes a hard limit on WALK, CAR and BICYCLE modes (see:
\url{http://docs.opentripplanner.org/en/latest/OTP2-MigrationGuide/#router-config}).}

\item{walkReluctance}{A single numeric value. A multiplier for how bad walking is
compared to being in transit for equal lengths of time. Default = 2.}

\item{waitReluctance}{A single numeric value. A multiplier for how bad waiting for a
transit vehicle is compared to being on a transit vehicle. This should be greater
than 1 and less than \code{walkReluctance} (see API docs). Default = 1.}

\item{arriveBy}{Logical. Whether a trip should depart (FALSE) or arrive (TRUE) at the specified
date and time. Default is FALSE.}

\item{transferPenalty}{Integer. An additional penalty added to boardings after
the first. The value is in OTP's internal weight units, which are roughly equivalent to seconds.
Set this to a high value to discourage transfers. Default is 0.}

\item{minTransferTime}{Integer. The minimum time, in seconds, between successive
trips on different vehicles. This is designed to allow for imperfect schedule
adherence. This is a minimum; transfers over longer distances might use a longer time.
Default is 0.}

\item{maxItineraries}{Integer. Controls the number of trip itineraries that
are returned when \code{detail} is set to TRUE. This is not an OTP parameter.
All suggested itineraries are allowed to be returned by the OTP server. The function
will return them to the user in the order they were provided by OTP up to the maximum
specified by this parameter. Default is 1. This is an alternative to using the
OTP \code{maxNumItineraries} parameter which has problematic behaviour.}

\item{detail}{Logical. When set to FALSE a single trip time is returned.
When set to TRUE one or more detailed trip itineraries are returned (dependent on \code{maxItineraries}).
Default is FALSE.}

\item{includeLegs}{Logical. Determines whether or not details of each
journey leg are returned. If TRUE then a nested dataframe of journeys legs will be returned
for each itinerary if \code{detail} is also TRUE. Default is FALSE.}

\item{extra.params}{A list of any other parameters accepted by the OTP API PlannerResource entry point. For
advanced users. Be aware that otpr will carry out no validation of these additional
parameters. They will be passed directly to the API.}
}
\value{
Returns a list of three or four elements. The first element in the list is \code{errorId}.
This is "OK" if OTP has not returned an error. Otherwise it is the OTP error code. The second element of list
varies:
\itemize{
\item If OTP has returned an error then \code{errorMessage} contains the OTP error message.
\item If there is no error and \code{detail} is FALSE then the \code{duration} in minutes is
returned as an integer. This is the duration of the top itinerary returned by the OTP server.

\item If there is no error and \code{detail} is TRUE then \code{itineraries} as a dataframe.
}
The third element of the list is \code{query}. This is a character string containing the URL
that was submitted to the OTP API.
}
\description{
In its simplest use case the function returns the time in minutes between an origin
and destination by the specified mode(s) for the top itinerary returned by OTP. If
\code{detail} is set to TRUE one or more detailed trip itineraries are returned,
including the time by each mode (if a multimodal trip), waiting time and the
number of transfers. Optionally, the details of each journey leg for each itinerary
can also be returned.
}
\details{
If you plan to use the function in simple-mode - where just the duration of the top itinerary is returned -
it is advisable to first review several detailed itineraries to ensure that the parameters
you have set are producing sensible results.

If requested using \code{includeLegs}, the itineraries dataframe will contain a column called 'legs'
which has a nested legs dataframe for each itinerary. Each legs dataframe will contain
a set of core columns that are consistent across all queries. However, as the OTP
API does not consistently return the same attributes for legs, there will be some variation
in columns returned. You should bare this in mind if your post processing
uses these columns (e.g. by checking for column existence).
}
\examples{
\dontrun{
otp_get_times(otpcon, fromPlace = c(53.48805, -2.24258), toPlace = c(53.36484, -2.27108))

otp_get_times(otpcon, fromPlace = c(53.48805, -2.24258), toPlace = c(53.36484, -2.27108),
mode = "BUS", date = "03-26-2019", time = "08:00:00")

otp_get_times(otpcon, fromPlace = c(53.48805, -2.24258), toPlace = c(53.36484, -2.27108),
mode = "BUS", date = "03-26-2019", time = "08:00:00", detail = TRUE)
}
}
