% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{Fps.DRKMEIV}
\alias{Fps.DRKMEIV}
\title{Logistic regression for observed treatment and instrument used for the (S)DRKMEIV estimator.}
\usage{
Fps.DRKMEIV(datalist, t0)
}
\arguments{
\item{datalist}{A list used to calculate the (S)DRKMEIV estimator including treatment named \code{a}, observed time named \code{obs.t}, censoring indicator (0, censored) named \code{delta}, and baseline covariates used to assign treatment named \code{l}. Notice that all the data in the datalist should be ordered by observed time.}

\item{t0}{A predetermined t.}
}
\value{
A list including the probability of receiving instrument given baseline covariates named \code{fzl}, the probability of receiving treatment given baseline covariates and instrument equaling 0 named \code{fal0}, the probability of receiving treatment given baseline covariates and instrument equaling 1 named \code{fal1}, the difference between \code{fal1} and \code{fal0} named \code{deltal}, and the censoring survival function given baseline covariates and treatment 1 or 0 named \code{surv.C.1} or \code{surv.C.0}.
}
\description{
Logistic regression for observed treatment and instrument used for the (S)DRKMEIV estimator.
}
\details{
More details can be found in references, \code{\link[otrKM]{DRKMEIV}}, and \code{\link[otrKM]{Genetic.optim.DRKMEIV}}.
}
\references{
{Xia, J., Zhan, Z., Zhang, J. (2022) An anti-confounding method for estimating optimal regime in a survival context using instrumental variable. Under Review.}
}
