% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{is_module_installed}
\alias{is_module_installed}
\title{Is module installed?}
\usage{
is_module_installed(repo)
}
\arguments{
\item{repo}{Module repo}
}
\value{
Logical
}
\description{
Check if a module is installed on your system.
}
\details{
Searches for \code{repo} among installed outsider modules. Returns
TRUE if found, else FALSE.
}
\examples{
library(outsider)
# NOT RUN (too slow for automated testing)
\dontrun{
  if (is_outsider_ready()) {
    # simplest repo
    repo <- 'dombennett/om..hello.world'
    # install
    module_install(repo = repo, force = TRUE, update = 'never')
    # is module_installed?
    (is_module_installed(repo = repo))
    # uninstall
    module_uninstall(repo)
  }
}
}
\seealso{
Other public: 
\code{\link{module_details}()},
\code{\link{module_functions}()},
\code{\link{module_help}()},
\code{\link{module_import}()},
\code{\link{module_installed}()},
\code{\link{module_install}()},
\code{\link{module_search}()},
\code{\link{module_uninstall}()}
}
\concept{public}
