% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpeti_mun.R
\name{getpeti_mun}
\alias{getpeti_mun}
\title{Collects municipal level data from the PETI (Child Slave Labour Erradication Program) database.}
\usage{
getpeti_mun(IBGECODE, AAAA, MM, PAGE = 1)
}
\arguments{
\item{IBGECODE}{IBGE Unique Identifier of the municipality which you want the data. The list of municipalities and its codes might be requested with the function owdbr::munlist()}

\item{AAAA}{Year of the Data (AAAA format)}

\item{MM}{Month of the Data (MM format)}

\item{PAGE}{Request's page. Default= 1.}
}
\value{
a tibble with the requested data, if there are more than one IBGECODE, returns all of them in the same tibble.
\describe{
  \item{dataReferencia}{Reference date}
  \item{valor}{Amount of money invested in the municipality.}
  \item{quantidadeBeneficiados}{Number of citizens wich are enrolled in the program in that moment}
  \item{municipio.codigoIBGE}{IBGE code of the municipality.}
  \item{municipio.nomeIBGE}{Name of the municipality.}
  \item{municipio.pais}{Country of the municipality.}
  \item{municipio.uf.sigla}{Abbreviation of name of the state in which the municipality is.}
  \item{municipio.uf.nome}{Full name of the state in wich the municipality is.}
  \item{tipo.id}{Type}
  \item{tipo.descricao}{Abbreviation of the program's name.}
  \item{tipo.descricaoDetalhada}{Full name of the program.}
}
}
\description{
PETI (Child Slave Labour Erradication Program) is a brazilian social welfare program that provides financial support for poor families. Its objective is to protect these families children from any type of work before the age of 16 years old, with that, the Federal Government expect them to keep going to school.
This function collects municipal level data from the program, some data like the number of citizens in a municipality wich are enrolled in the program, and the total amound of money invested by the program in that city.
}
\examples{
getpeti_mun('3304557', AAAA='2015', MM='05', PAGE=1)


}
\author{
Joao Pedro Oliveira dos Santos, International Relations Institute, Pontifical Catholic University of Rio de Janeiro
}
