% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owid_embed.R
\name{owid_embed}
\alias{owid_embed}
\title{Embed Our World in Data Chart in HTML}
\usage{
owid_embed(url, width = "100\%", height = "600px")
}
\arguments{
\item{url}{A character string containing the URL of the Our World in
Data chart. Must begin with "https://ourworldindata.org/grapher/".}

\item{width}{A character string specifying the width of the iframe.
Default is "100\%".}

\item{height}{A character string specifying the height of the iframe.
Default is "600px".}
}
\value{
A character string containing the HTML iframe to embed the chart.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Creates HTML code to embed an interactive chart from Our World in Data
into an HTML document using an iframe.
}
\examples{
owid_embed(
  "https://ourworldindata.org/grapher/co2-emissions-per-capita",
  width = "90\%",
  height = "500px"
)

}
