% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WCSCoverageSpatialDomain.R
\docType{class}
\name{WCSCoverageSpatialDomain}
\alias{WCSCoverageSpatialDomain}
\title{WCSCoverageSpatialDomain}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} modelling a WCS coverage spatial domain
}
\description{
WCSCoverageSpatialDomain

WCSCoverageSpatialDomain
}
\note{
Class used internally by ows4R.
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Coverage}
\keyword{OGC}
\keyword{WCS}
\keyword{domain}
\keyword{spatial}
\section{Super class}{
\code{\link[ows4R:OGCAbstractObject]{ows4R::OGCAbstractObject}} -> \code{WCSCoverageSpatialDomain}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{envelopes}}{envelopes. For WCS 1.0}

\item{\code{BoundingBox}}{bounding box. For WCS 1.1}

\item{\code{grids}}{For WCS 1.0}

\item{\code{GridCRS}}{grid CRS. For WCS 1.1}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WCSCoverageSpatialDomain-new}{\code{WCSCoverageSpatialDomain$new()}}
\item \href{#method-WCSCoverageSpatialDomain-getEnvelopes}{\code{WCSCoverageSpatialDomain$getEnvelopes()}}
\item \href{#method-WCSCoverageSpatialDomain-getBoundingBox}{\code{WCSCoverageSpatialDomain$getBoundingBox()}}
\item \href{#method-WCSCoverageSpatialDomain-getGrids}{\code{WCSCoverageSpatialDomain$getGrids()}}
\item \href{#method-WCSCoverageSpatialDomain-getGridCRS}{\code{WCSCoverageSpatialDomain$getGridCRS()}}
\item \href{#method-WCSCoverageSpatialDomain-clone}{\code{WCSCoverageSpatialDomain$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="ERROR"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-ERROR'><code>ows4R::OGCAbstractObject$ERROR()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="INFO"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-INFO'><code>ows4R::OGCAbstractObject$INFO()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="WARN"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-WARN'><code>ows4R::OGCAbstractObject$WARN()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="encode"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-encode'><code>ows4R::OGCAbstractObject$encode()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClass"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClass'><code>ows4R::OGCAbstractObject$getClass()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClassName"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClassName'><code>ows4R::OGCAbstractObject$getClassName()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getNamespaceDefinition"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getNamespaceDefinition'><code>ows4R::OGCAbstractObject$getNamespaceDefinition()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="isFieldInheritedFrom"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-isFieldInheritedFrom'><code>ows4R::OGCAbstractObject$isFieldInheritedFrom()</code></a></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="logger"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-logger'><code>ows4R::OGCAbstractObject$logger()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSpatialDomain-new"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSpatialDomain-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{WCSCoverageDomain}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSpatialDomain$new(xmlObj, serviceVersion, owsVersion, logger = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xmlObj}}{an object of class \link{XMLInternalNode-class} to initialize from XML}

\item{\code{serviceVersion}}{service version}

\item{\code{owsVersion}}{OWS version}

\item{\code{logger}}{logger}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSpatialDomain-getEnvelopes"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSpatialDomain-getEnvelopes}{}}}
\subsection{Method \code{getEnvelopes()}}{
Get envelopes. Method that applies to WCS 1.0 only
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSpatialDomain$getEnvelopes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of objects of class \link{GMLEnvelope} or \link{GMLEnvelopeWithTimePeriod}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSpatialDomain-getBoundingBox"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSpatialDomain-getBoundingBox}{}}}
\subsection{Method \code{getBoundingBox()}}{
Get bounding boxes. Method that applies to WCS 1.1 only
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSpatialDomain$getBoundingBox()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of objects of class \link{OWSBoundingBox}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSpatialDomain-getGrids"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSpatialDomain-getGrids}{}}}
\subsection{Method \code{getGrids()}}{
Get grids. Method that applies to WCS 1.0 only
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSpatialDomain$getGrids()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of of objects of class \link{GMLGrid} or \link{GMLRectifiedGrid}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSpatialDomain-getGridCRS"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSpatialDomain-getGridCRS}{}}}
\subsection{Method \code{getGridCRS()}}{
Get Grid CRS. Method that applies to WCS 1.1 only
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSpatialDomain$getGridCRS()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of objects of class \link{WCSGridCRS}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageSpatialDomain-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageSpatialDomain-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageSpatialDomain$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
