ozRegion <- function(states = TRUE, coast = TRUE, xlim = NULL,
		 ylim = NULL, eps = 0.25,
		 sections = NULL, visible = NULL)
{
  if (!is.null(xlim) || !is.null(ylim)) {
    if (is.null(xlim))
      rx <- c(113, 154)
    else
      rx <- xlim
    if (is.null(ylim))
      ry <- c(-44, -10)
    else
      ry <- ylim
  }
  else {
    rx <- NULL
    ry <- NULL
    if (!is.null(sections)) {
      for(i in sections) {
	rx <- range(c(rx, .Oz.limits[[i]]$x))
	ry <- range(c(ry, .Oz.limits[[i]]$y))
      }
      rx <- rx + c( - eps, eps)
      ry <- ry + c( - eps, eps)
    }
    else {
      rx <- c(113, 154)
      ry <- c(-44, -10)
    }
  }
  option <- rep(FALSE, 16)		# there are 16 border sections
  if (!is.null(visible)) {
    option[visible] <- TRUE
  }
  else if (!states) {
    option[1:7] <- TRUE    
  }
  else if (!coast) {
    option[8:16] <- TRUE
  }
  else if (!is.null(sections)) {
    option[sections] <- TRUE
  }
  else
    option[1:16] <- TRUE

  ".Oz.in2la" <- function(internal) {
    latitude <- (internal - 1998)/52.600000000000001 - 10
    latitude
  }
  ".Oz.in2lo" <- function(internal) {
    longitude <- (internal - 420)/52.600000000000001 + 120
    longitude
  }
  ".Oz.rc" <- function(r1, r2) {
    !((max(r1) < min(r2)) || (min(r1) > max(r2)))
  }

  for(i in 1:16) {
    option[i] <- (option[i] &&
		  .Oz.rc(rx, .Oz.limits[[i]]$x) && 
		  .Oz.rc(ry, .Oz.limits[[i]]$y))
  }
  lines <- list(sum(option))
  index <- 1
  for (i in (1:16)[option]) {
    lines[[index]] <- list(x=.Oz.in2lo(.Oz.sections[[i]]$x), 
      y=.Oz.in2la(.Oz.sections[[i]]$y))
    index <- index + 1
  }
  region <- list(rangex=rx, rangey=ry, lines=lines)
  class(region) <- "ozRegion"
  region
}

oz <- function(states = TRUE, coast = TRUE, xlim = NULL,
               ylim = NULL, add = FALSE, ar = 1, eps = 0.25,
               sections = NULL, visible = NULL, ...) {
  if (add) {
    xlim <- par("usr")[1:2]
    ylim <- par("usr")[3:4]
  }
  region <- ozRegion(states, coast, xlim, ylim, eps, sections, visible)
  oldpar <- par(err = -1)
  on.exit(par(oldpar))
  if(!add) {
    frame()
    pxy <- par("pin")
    rx <- region$rangex
    ry <- region$rangey
    dx <- ar * (rx[2] - rx[1])
    dy <- ry[2] - ry[1]
    coord <- min(pxy[1] / dx, pxy[2]/dy)
    xextra <- ((pxy[1] / coord - dx) * 0.5)/ar
    yextra <- (pxy[2] / coord - dy) * 0.5
    par(usr = c(rx[1] - xextra, rx[2] + xextra,
	        ry[1] - yextra, ry[2] + yextra))
  }
  for(i in region$lines)
    lines(i$x, i$y, ...)
}

"nsw"<-
function(...)
{
  oz(sections = c(4, 13:15), ...)
}
"nt"<-
function(...)
{
  oz(sections = c(2, 9:11), ...)
}
"qld"<-
function(...)
{
  oz(sections = c(3, 11:13), ...)
}
"sa"<-
function(...)
{
  oz(sections = c(7, 8, 10, 12, 14, 16), ...)
}
"tas"<-
function(...)
{
  oz(sections = 6, ...)
}
"vic"<-
function(...)
{
  oz(sections = c(5, 15, 16), ...)
}
"wa"<-
function(...)
{
  oz(sections = c(1, 8, 9), ...)
}

".Oz.cities"<-
list(name = c("Adelaide", "Albury", "Alice_Springs", "Brisbane", "Broome",
	 "Cairns", "Canberra", "Darwin", "Hobart", "Melbourne", "Newcastle",
	 "Perth", "Sydney", "Townsville"),
     x = c(138.5333333333333, 146.83333333333329, 133.8833333333333,
	 152.41666666666671, 122.25, 145.84999999999999, 149.1333333333333,
	 130.83333333333329, 147.34999999999999, 145, 151.81666666666669,
	 115.8666666666667, 151.16666666666671, 146.75),
     y = c(-34.916666666666657, -36, -23.600000000000001, -27, -18,
	 -16.916666666666671, -35.25, -12.33333333333333,
	 -42.833333333333343, -37.666666666666657, -32.866666666666667,
	 -31.949999999999999, -33.883333333333333, -19.25))

".Oz.limits" <-
list(list(x = c(113.194, 129.011),
	  y = c(-35.113999999999997, -13.763999999999999)),
     list(x = c(129.011, 138.00399999999999),
	  y = c(-16.369, -11.045999999999999)),
     list(x = c(138.00399999999999, 153.47900000000001),
	  y = c(-28.137, -10.932)),
     list(x = c(149.65799999999999, 153.66900000000001),
	  y = c(-37.451999999999998, -28.079999999999998)),
     list(x = c(140.95099999999999, 149.791),
	  y = c(-39.048999999999999, -37.414000000000001)),
     list(x = c(144.63900000000001, 148.346),
	  y = c(-43.593000000000004, -40.589000000000013)),
     list(x = c(129.011, 140.97),
	  y = c(-37.966000000000008, -31.425999999999998)),
     list(x = c(129.011, 129.011),
	  y = c(-31.577999999999999, -25.989000000000001)),
     list(x = c(129.011, 129.011),
	  y = c(-25.989000000000001, -14.829000000000001)),
     list(x = c(129.011, 138.00399999999999),
	  y = c(-25.989000000000001, -25.989000000000001)),
     list(x = c(138.00399999999999, 138.00399999999999),
	  y = c(-25.989000000000001, -16.369)),
     list(x = c(138.00399999999999, 141.00800000000001),
	  y = c(-28.992000000000001, -25.989000000000001)),
     list(x = c(141.00800000000001, 153.47900000000001),
	  y = c(-29.163, -28.137)),
     list(x = c(141.00800000000001, 141.00800000000001),
	  y = c(-34.048999999999999, -28.992000000000001)),
     list(x = c(141.00800000000001, 149.65799999999999),
	  y = c(-37.414000000000001, -33.915999999999997)), 
     list(x = c(140.95099999999999, 141.00800000000001),
	  y = c(-37.927999999999997, -34.048999999999999)))

".Oz.sections" <-
list(list(x = c(894, 879, 872, 867, 861, 848, 835, 832, 825, 810, 797, 791,
	      785, 780, 780, 776, 767, 750, 744, 738, 735, 730, 727, 639,
	      636, 633, 632, 632, 629, 626, 623, 622, 621, 620, 618, 616,
	      612, 611, 608, 608, 606, 604, 600, 598, 596, 596, 594, 592,
	      591, 587, 586, 581, 580, 578, 577, 534, 530, 526, 525, 523,
	      522, 519, 518, 516, 515, 514, 511, 509, 502, 500, 497, 494,
	      489, 444, 437, 431, 429, 425, 423, 423, 422, 420, 418, 414,
	      410, 409, 408, 408, 404, 404, 402, 401, 400, 399, 396, 396,
	      395, 395, 394, 394, 395, 395, 393, 392, 391, 389, 388, 388,
	      389, 389, 387, 382, 381, 381, 380, 379, 377, 376, 373, 369,
	      369, 370, 369, 368, 367, 366, 365, 364, 363, 363, 362, 360,
	      357, 355, 354, 355, 354, 354, 353, 353, 351, 350, 342, 342,
	      339, 339, 337, 337, 336, 336, 335, 334, 335, 330, 322, 322,
	      328, 329, 328, 327, 327, 328, 329, 329, 328, 327, 327, 326,
	      324, 323, 321, 320, 318, 317, 310, 308, 307, 306, 304, 304,
	      278, 279, 277, 274, 271, 269, 267, 266, 266, 265, 264, 262,
	      259, 258, 257, 255, 250, 248, 246, 242, 239, 234, 233, 230,
	      228, 227, 227, 229, 230, 232, 228, 226, 225, 225, 226, 226,
	      224, 222, 220, 217, 212, 210, 207, 206, 202, 202, 200, 199,
	      196, 196, 195, 190, 187, 184, 182, 178, 174, 157, 159, 161,
	      162, 164, 169, 170, 171, 176, 179, 181, 183, 185, 187, 187,
	      188, 188, 190, 190, 192, 192, 191, 189, 189, 188, 188, 189,
	      191, 191, 190, 191, 193, 194, 194, 195, 196, 197, 195, 195,
	      194, 194, 195, 195, 196, 196, 197, 199, 199, 199, 198, 199,
	      198, 200, 201, 203, 202, 202, 199, 198, 198, 197, 196, 197,
	      196, 197, 197, 196, 197, 197, 196, 195, 195, 193, 193, 189,
	      185, 184, 180, 178, 175, 171, 171, 169, 168, 165, 163, 161,
	      157, 159, 159, 160, 160, 158, 158, 157, 158, 160, 161, 161,
	      160, 159, 157, 159, 159, 158, 158, 156, 154, 154, 151, 148,
	      143, 138, 137, 137, 138, 137, 137, 135, 133, 131, 129, 127,
	      126, 119, 116, 113, 113, 112, 112, 113, 113, 112, 112, 110,
	      108, 106, 100, 98, 95, 89, 87, 84, 83, 81, 80, 75, 74, 73, 70,
	      69, 66, 65, 64, 64, 63, 62, 63, 67, 68, 68, 69, 70, 70, 71,
	      71, 72, 74, 74, 75, 76, 78, 78, 80, 80, 82, 82, 84, 84, 86,
	      86, 87, 89, 90, 91, 93, 96, 97, 99, 99, 98, 97, 96, 95, 90,
	      88, 86, 85, 84, 82, 82, 81, 81, 80, 80, 81, 80, 78, 75, 74,
	      75, 79, 79, 80, 81, 81, 82, 85, 85, 86, 90, 92, 92, 91, 92,
	      94, 96, 98, 98, 100, 100, 101, 103, 101, 97, 91, 89, 89, 88,
	      86, 84, 80, 76, 75, 78, 79, 79, 78, 75, 74, 72, 77, 78, 79,
	      80, 83, 87, 88, 90, 93, 95, 96, 96, 94, 94, 92, 91, 90, 89,
	      93, 95, 96, 96, 100, 104, 106, 107, 109, 110, 110, 111, 111,
	      95, 94, 94, 92, 92, 91, 91, 89, 87, 88, 89, 91, 92, 95, 97,
	      97, 100, 100, 102, 103, 106, 109, 110, 112, 114, 114, 112,
	      112, 111, 109, 109, 110, 110, 112, 112, 113, 113, 114, 114,
	      115, 115, 116, 117, 117, 118, 120, 122, 124, 126, 127, 128,
	      128, 129, 129, 132, 134, 135, 137, 138, 141, 143, 146, 151,
	      161, 163, 163, 164, 166, 167, 169, 166, 167, 168, 170, 171,
	      171, 174, 176, 177, 179, 180, 181, 184, 185, 189, 191, 194,
	      200, 203, 207, 207, 211, 212, 221, 222, 222, 227, 227, 226,
	      228, 232, 237, 242, 243, 244, 247, 249, 251, 252, 251, 252,
	      254, 255, 257, 257, 255, 256, 263, 264, 264, 264, 263, 264,
	      267, 268, 269, 272, 273, 274, 275, 276, 276, 275, 276, 277,
	      286, 289, 294, 297, 301, 304, 305, 307, 308, 313, 315, 316,
	      316, 318, 319, 324, 340, 344, 346, 348, 353, 359, 362, 367,
	      368, 370, 372, 374, 377, 380, 383, 387, 389, 389, 390, 392,
	      393, 397, 399, 403, 409, 412, 414, 417, 446, 452, 456, 460,
	      463, 469, 475, 484, 489, 491, 492, 495, 499, 504, 505, 505,
	      506, 506, 507, 507, 508, 512, 515, 516, 514, 514, 517, 520,
	      523, 531, 531, 534, 535, 535, 539, 543, 543, 542, 539, 538,
	      538, 537, 537, 535, 534, 532, 532, 534, 534, 533, 534, 533,
	      533, 535, 536, 540, 541, 540, 542, 544, 546, 548, 552, 554,
	      555, 555, 554, 554, 556, 559, 563, 565, 567, 569, 571, 571,
	      572, 579, 581, 578, 577, 577, 579, 580, 580, 581, 583, 583,
	      584, 585, 587, 589, 589, 591, 593, 595, 598, 599, 603, 606,
	      606, 608, 610, 610, 611, 610, 608, 608, 607, 614, 616, 618,
	      620, 621, 620, 621, 622, 621, 618, 613, 609, 607, 604, 602,
	      602, 604, 606, 608, 609, 607, 603, 602, 611, 612, 610, 606,
	      606, 607, 610, 611, 612, 615, 615, 613, 613, 615, 616, 617,
	      618, 618, 617, 617, 616, 616, 617, 619, 620, 625, 626, 629,
	      631, 631, 632, 635, 635, 637, 637, 638, 638, 639, 640, 641,
	      643, 644, 644, 646, 648, 650, 650, 649, 649, 648, 652, 653,
	      652, 657, 660, 661, 661, 659, 658, 653, 653, 651, 651, 650,
	      650, 649, 651, 651, 650, 650, 651, 651, 660, 662, 662, 663,
	      663, 665, 665, 666, 666, 665, 665, 666, 668, 668, 670, 671,
	      673, 674, 676, 679, 679, 681, 681, 682, 687, 688, 688, 687,
	      687, 685, 681, 680, 679, 678, 677, 678, 685, 683, 680, 678,
	      677, 676, 675, 678, 681, 684, 685, 686, 685, 685, 686, 688,
	      689, 690, 691, 691, 690, 692, 692, 694, 697, 698, 699, 699,
	      700, 701, 702, 702, 704, 705, 705, 709, 713, 712, 712, 711,
	      709, 707, 706, 704, 703, 703, 704, 703, 704, 704, 703, 703,
	      702, 701, 700, 699, 698, 698, 697, 697, 698, 698, 697, 697,
	      695, 694, 693, 693, 695, 695, 696, 696, 697, 698, 698, 697,
	      697, 698, 697, 696, 697, 696, 700, 700, 701, 701, 703, 704,
	      704, 706, 708, 710, 711, 712, 714, 715, 716, 717, 717, 718,
	      717, 718, 718, 717, 718, 718, 717, 717, 714, 713, 713, 714,
	      715, 716, 717, 719, 721, 721, 720, 719, 718, 718, 719, 719,
	      721, 722, 725, 726, 726, 727, 727, 730, 730, 734, 734, 733,
	      733, 732, 732, 735, 737, 739, 739, 740, 740, 741, 741, 740,
	      740, 741, 744, 745, 744, 743, 741, 738, 737, 736, 738, 739,
	      741, 742, 744, 744, 742, 740, 739, 744, 747, 749, 750, 751,
	      751, 750, 750, 749, 749, 750, 751, 751, 748, 748, 752, 754,
	      755, 756, 755, 755, 754, 755, 759, 762, 764, 765, 766, 766,
	      765, 764, 764, 765, 765, 764, 765, 767, 767, 768, 769, 771,
	      770, 770, 771, 771, 773, 775, 776, 778, 777, 773, 774, 782,
	      783, 784, 784, 782, 781, 777, 775, 777, 780, 789, 790, 789,
	      789, 790, 792, 792, 793, 795, 799, 801, 804, 805, 809, 810,
	      812, 814, 815, 817, 819, 819, 818, 819, 820, 821, 821, 822,
	      823, 826, 829, 830, 834, 835, 835, 836, 837, 841, 848, 849,
	      851, 851, 852, 852, 853, 853, 854, 854, 855, 856, 855, 853,
	      853, 851, 850, 849, 848, 848, 847, 847, 845, 845, 846, 845,
	      845, 844, 844, 846, 848, 848, 849, 849, 850, 850, 851, 851,
	      852, 852, 853, 854, 855, 856, 857, 857, 858, 857, 856, 855,
	      855, 854, 854, 852, 854, 855, 857, 859, 860, 861, 861, 862,
	      863, 863, 865, 865, 864, 863, 861, 861, 862, 863, 865, 866,
	      867, 867, 870, 872, 873, 874, 876, 877, 878, 879, 884, 888,
	      889, 892, 893, 894),
	  y = c(863, 857, 852, 851, 847, 844, 840, 838, 838, 834, 831, 831,
	      829, 829, 828, 827, 827, 829, 832, 832, 831, 830, 828, 793,
	      791, 790, 789, 788, 783, 779, 774, 768, 765, 756, 753, 751,
	      750, 749, 743, 741, 740, 741, 741, 739, 739, 740, 740, 741,
	      740, 740, 737, 735, 735, 736, 738, 735, 735, 738, 741, 743,
	      745, 746, 746, 745, 745, 744, 743, 744, 746, 747, 746, 747,
	      747, 742, 740, 741, 741, 740, 742, 744, 744, 743, 741, 738,
	      738, 737, 737, 736, 735, 734, 733, 732, 730, 729, 728, 726,
	      724, 721, 720, 717, 716, 715, 715, 716, 716, 715, 714, 712,
	      712, 710, 710, 712, 711, 710, 708, 708, 709, 709, 712, 712,
	      711, 711, 712, 712, 713, 713, 712, 713, 711, 709, 708, 708,
	      709, 708, 707, 706, 706, 705, 704, 703, 701, 701, 698, 697,
	      696, 694, 692, 690, 689, 688, 686, 686, 685, 685, 680, 681,
	      686, 685, 685, 684, 683, 683, 681, 682, 680, 681, 680, 681,
	      681, 682, 682, 681, 680, 679, 679, 680, 682, 682, 680, 679,
	      681, 683, 683, 680, 680, 681, 681, 680, 679, 677, 678, 679,
	      679, 677, 677, 678, 678, 679, 679, 677, 677, 679, 679, 681,
	      681, 682, 683, 683, 684, 684, 688, 688, 687, 685, 685, 684,
	      684, 687, 687, 689, 689, 690, 690, 692, 694, 696, 697, 701,
	      704, 705, 708, 713, 715, 716, 718, 718, 719, 759, 757, 757,
	      756, 756, 754, 754, 753, 756, 757, 762, 765, 771, 772, 776,
	      776, 778, 780, 781, 786, 789, 795, 802, 806, 809, 814, 816,
	      818, 812, 810, 808, 807, 810, 813, 815, 816, 818, 819, 821,
	      822, 834, 836, 843, 845, 846, 848, 848, 849, 848, 849, 848,
	      840, 840, 843, 845, 846, 845, 842, 842, 844, 848, 850, 851,
	      851, 850, 851, 851, 850, 851, 853, 853, 854, 859, 863, 873,
	      877, 879, 883, 886, 894, 900, 905, 910, 914, 919, 926, 929,
	      933, 934, 936, 937, 938, 945, 948, 953, 956, 956, 958, 959,
	      960, 962, 969, 975, 980, 983, 987, 990, 995, 999, 1004, 1007,
	      1010, 1017, 1020, 1023, 1027, 1028, 1032, 1034, 1038, 1041,
	      1042, 1044, 1046, 1053, 1055, 1056, 1058, 1061, 1073, 1077,
	      1079, 1081, 1084, 1092, 1095, 1100, 1109, 1113, 1117, 1123,
	      1126, 1128, 1130, 1132, 1134, 1139, 1140, 1142, 1145, 1148,
	      1151, 1153, 1153, 1154, 1156, 1156, 1155, 1155, 1157, 1163,
	      1163, 1162, 1150, 1149, 1146, 1147, 1155, 1158, 1160, 1159,
	      1154, 1152, 1148, 1149, 1146, 1140, 1136, 1133, 1136, 1134,
	      1132, 1130, 1128, 1130, 1132, 1132, 1134, 1136, 1140, 1144,
	      1146, 1150, 1152, 1155, 1157, 1158, 1160, 1164, 1167, 1168,
	      1170, 1173, 1173, 1172, 1172, 1174, 1176, 1178, 1181, 1185,
	      1189, 1191, 1190, 1186, 1183, 1183, 1179, 1176, 1173, 1167,
	      1162, 1156, 1154, 1153, 1152, 1159, 1160, 1163, 1156, 1151,
	      1149, 1197, 1199, 1210, 1216, 1219, 1227, 1229, 1231, 1235,
	      1238, 1240, 1243, 1244, 1246, 1248, 1251, 1252, 1255, 1259,
	      1268, 1272, 1272, 1276, 1281, 1285, 1288, 1292, 1295, 1302,
	      1307, 1326, 1333, 1335, 1337, 1337, 1342, 1344, 1347, 1352,
	      1357, 1360, 1370, 1376, 1377, 1379, 1379, 1380, 1381, 1381,
	      1383, 1317, 1319, 1321, 1325, 1329, 1331, 1332, 1336, 1338,
	      1340, 1341, 1346, 1347, 1354, 1356, 1359, 1365, 1368, 1371,
	      1374, 1379, 1382, 1381, 1382, 1378, 1374, 1370, 1367, 1364,
	      1363, 1361, 1359, 1358, 1358, 1347, 1345, 1344, 1342, 1339,
	      1339, 1338, 1339, 1342, 1344, 1345, 1345, 1344, 1342, 1342,
	      1341, 1343, 1351, 1354, 1360, 1368, 1370, 1372, 1374, 1378,
	      1380, 1382, 1384, 1385, 1390, 1390, 1388, 1388, 1392, 1392,
	      1393, 1393, 1394, 1393, 1394, 1394, 1393, 1393, 1394, 1395,
	      1395, 1396, 1396, 1399, 1401, 1405, 1405, 1408, 1408, 1410,
	      1416, 1417, 1424, 1424, 1428, 1430, 1431, 1432, 1433, 1433,
	      1433, 1435, 1438, 1440, 1440, 1441, 1442, 1444, 1445, 1448,
	      1449, 1449, 1450, 1449, 1450, 1449, 1445, 1444, 1444, 1443,
	      1445, 1443, 1442, 1441, 1444, 1443, 1443, 1446, 1446, 1444,
	      1443, 1441, 1440, 1439, 1439, 1438, 1438, 1439, 1439, 1440,
	      1440, 1441, 1442, 1443, 1443, 1448, 1448, 1451, 1453, 1454,
	      1455, 1457, 1457, 1458, 1458, 1459, 1459, 1461, 1464, 1466,
	      1470, 1472, 1473, 1475, 1477, 1476, 1476, 1475, 1474, 1475,
	      1475, 1474, 1474, 1476, 1476, 1478, 1478, 1477, 1477, 1476,
	      1484, 1486, 1488, 1489, 1491, 1494, 1496, 1503, 1506, 1509,
	      1512, 1517, 1521, 1525, 1527, 1530, 1532, 1536, 1538, 1543,
	      1544, 1545, 1547, 1549, 1553, 1554, 1557, 1557, 1558, 1566,
	      1569, 1574, 1577, 1578, 1578, 1582, 1584, 1585, 1586, 1586,
	      1584, 1584, 1583, 1582, 1584, 1586, 1589, 1594, 1602, 1607,
	      1611, 1614, 1618, 1622, 1625, 1627, 1629, 1631, 1633, 1636,
	      1638, 1637, 1636, 1637, 1640, 1642, 1644, 1645, 1646, 1646,
	      1649, 1651, 1656, 1659, 1661, 1664, 1666, 1666, 1664, 1661,
	      1658, 1655, 1653, 1651, 1650, 1649, 1648, 1644, 1642, 1641,
	      1635, 1632, 1630, 1627, 1625, 1622, 1615, 1611, 1609, 1606,
	      1613, 1617, 1620, 1622, 1624, 1626, 1628, 1631, 1632, 1632,
	      1630, 1630, 1631, 1633, 1635, 1635, 1637, 1640, 1642, 1649,
	      1653, 1653, 1657, 1659, 1661, 1661, 1659, 1660, 1662, 1664,
	      1665, 1666, 1666, 1668, 1670, 1670, 1673, 1673, 1676, 1676,
	      1675, 1676, 1677, 1678, 1679, 1680, 1680, 1679, 1679, 1678,
	      1677, 1676, 1676, 1673, 1672, 1672, 1670, 1670, 1669, 1669,
	      1668, 1669, 1668, 1668, 1667, 1666, 1665, 1664, 1663, 1662,
	      1660, 1660, 1658, 1658, 1659, 1661, 1666, 1668, 1670, 1673,
	      1675, 1676, 1678, 1680, 1681, 1681, 1684, 1687, 1695, 1694,
	      1690, 1683, 1684, 1687, 1692, 1693, 1694, 1697, 1702, 1704,
	      1706, 1708, 1709, 1711, 1711, 1710, 1711, 1712, 1713, 1714,
	      1716, 1717, 1720, 1720, 1721, 1722, 1722, 1721, 1719, 1717,
	      1716, 1715, 1715, 1712, 1708, 1708, 1709, 1709, 1711, 1713,
	      1714, 1716, 1718, 1719, 1719, 1717, 1718, 1720, 1721, 1723,
	      1728, 1730, 1729, 1727, 1727, 1728, 1730, 1731, 1733, 1734,
	      1734, 1736, 1737, 1738, 1739, 1739, 1738, 1738, 1737, 1734,
	      1732, 1730, 1729, 1727, 1727, 1726, 1726, 1727, 1726, 1726,
	      1725, 1726, 1725, 1725, 1726, 1726, 1729, 1729, 1730, 1731,
	      1731, 1732, 1731, 1732, 1732, 1733, 1734, 1735, 1736, 1738,
	      1738, 1739, 1739, 1738, 1739, 1738, 1738, 1741, 1742, 1743,
	      1746, 1747, 1749, 1750, 1752, 1752, 1753, 1754, 1754, 1755,
	      1757, 1758, 1758, 1758, 1757, 1758, 1757, 1757, 1758, 1758,
	      1757, 1757, 1757, 1758, 1757, 1758, 1758, 1757, 1756, 1756,
	      1757, 1757, 1756, 1757, 1757, 1756, 1757, 1758, 1760, 1761,
	      1761, 1762, 1763, 1763, 1764, 1765, 1766, 1767, 1770, 1772,
	      1774, 1774, 1775, 1774, 1774, 1772, 1772, 1770, 1770, 1768,
	      1767, 1766, 1764, 1762, 1760, 1761, 1761, 1762, 1760, 1759,
	      1756, 1750, 1749, 1753, 1757, 1758, 1760, 1760, 1761, 1761,
	      1762, 1762, 1763, 1763, 1764, 1767, 1768, 1770, 1774, 1775,
	      1774, 1776, 1778, 1779, 1783, 1786, 1788, 1789, 1788, 1787,
	      1789, 1789, 1787, 1790, 1790, 1791, 1793, 1793, 1794, 1793,
	      1793, 1792, 1788, 1787, 1785, 1784, 1783, 1781, 1780, 1779,
	      1776, 1774, 1776, 1774, 1776, 1777, 1779, 1781, 1782, 1784,
	      1786, 1789, 1790, 1790, 1789, 1786, 1785, 1785, 1784, 1784,
	      1782, 1781, 1781, 1780, 1776, 1775, 1775, 1777, 1779, 1780,
	      1782, 1783, 1783, 1782, 1784, 1786, 1786, 1788, 1790, 1790,
	      1789, 1789, 1791, 1793, 1796, 1798, 1800, 1800, 1799, 1799,
	      1798, 1798, 1797, 1797, 1793, 1792, 1791, 1790, 1790, 1791,
	      1791, 1790, 1790, 1789, 1789, 1788, 1787, 1786, 1784, 1785,
	      1785, 1783, 1783, 1782, 1776, 1775, 1772, 1770, 1769, 1766,
	      1762, 1762, 1761, 1760, 1758, 1756, 1752, 1752, 1750, 1749,
	      1748, 1747, 1747, 1746, 1746, 1744, 1744, 1743, 1743, 1741,
	      1740, 1740, 1741, 1741, 1739, 1734, 1732, 1731, 1726, 1724,
	      1722, 1720, 1715, 1713, 1710, 1706, 1710, 1716, 1719, 1722,
	      1723, 1722, 1722, 1720, 1719, 1715, 1714, 1712, 1711, 1711,
	      1709, 1711, 1716, 1717, 1719, 1720, 1722, 1724, 1728, 1732,
	      1734, 1736, 1738, 1739, 1739, 1740, 1736, 1735, 1736, 1737,
	      1739, 1742, 1743, 1743, 1745, 1746, 1747, 1747, 1746, 1745,
	      1745, 1744, 1744, 1743, 1744, 1743, 1743, 1742, 1742, 1741,
	      1741, 1742, 1743, 1743, 1744, 1744) ),
     list(x = c(894, 897, 898, 899, 901, 902, 906, 907, 911, 912, 913, 917,
	      917, 919, 920, 920, 921, 921, 923, 923, 925, 925, 926, 927,
	      928, 929, 930, 932, 934, 934, 932, 931, 929, 929, 928, 928,
	      929, 935, 936, 939, 941, 942, 942, 941, 938, 935, 933, 930,
	      929, 926, 925, 925, 928, 929, 931, 932, 930, 927, 926, 925,
	      924, 922, 921, 917, 916, 916, 917, 917, 918, 920, 924, 924,
	      925, 925, 926, 926, 925, 925, 926, 928, 928, 929, 931, 933,
	      933, 935, 935, 934, 935, 938, 938, 939, 939, 938, 938, 939,
	      940, 940, 941, 941, 942, 943, 944, 944, 945, 945, 946, 946,
	      953, 954, 956, 958, 959, 960, 961, 962, 964, 965, 965, 962,
	      961, 959, 957, 957, 958, 958, 957, 962, 963, 965, 965, 970,
	      970, 971, 972, 976, 978, 979, 980, 980, 981, 979, 977, 978,
	      978, 979, 980, 980, 981, 980, 980, 983, 984, 985, 986, 988,
	      989, 991, 992, 993, 993, 994, 994, 995, 996, 998, 998, 997,
	      999, 1000, 1001, 1001, 998, 996, 994, 993, 995, 996, 999,
	      1000, 1000, 998, 997, 995, 993, 993, 994, 996, 998, 1000,
	      1001, 1002, 1001, 1001, 1002, 1005, 1009, 1014, 1015, 1015,
	      1014, 1014, 1017, 1017, 1018, 1018, 1019, 1019, 1020, 1022,
	      1023, 1025, 1031, 1031, 1033, 1034, 1036, 1037, 1039, 1040,
	      1043, 1046, 1046, 1048, 1048, 1049, 1051, 1054, 1055, 1058,
	      1058, 1060, 1060, 1062, 1063, 1065, 1068, 1069, 1069, 1068,
	      1066, 1066, 1068, 1071, 1074, 1075, 1076, 1076, 1077, 1078,
	      1080, 1083, 1084, 1085, 1085, 1084, 1084, 1081, 1080, 1079,
	      1079, 1081, 1082, 1082, 1083, 1084, 1084, 1087, 1087, 1084,
	      1082, 1080, 1077, 1074, 1064, 1059, 1058, 1055, 1054, 1052,
	      1051, 1048, 1044, 1043, 1043, 1044, 1046, 1049, 1050, 1051,
	      1053, 1053, 1054, 1056, 1057, 1057, 1058, 1058, 1059, 1060,
	      1060, 1061, 1063, 1064, 1064, 1063, 1063, 1062, 1064, 1064,
	      1065, 1065, 1066, 1066, 1068, 1070, 1071, 1071, 1072, 1072,
	      1073, 1073, 1074, 1073, 1074, 1074, 1075, 1076, 1077, 1078,
	      1079, 1080, 1080, 1079, 1079, 1078, 1079, 1078, 1079, 1079,
	      1081, 1083, 1083, 1084, 1084, 1085, 1085, 1084, 1085, 1084,
	      1083, 1082, 1082, 1084, 1088, 1089, 1091, 1091, 1092, 1092,
	      1093, 1094, 1095, 1095, 1097, 1098, 1098, 1096, 1096, 1098,
	      1105, 1108, 1108, 1109, 1109, 1110, 1111, 1110, 1110, 1109,
	      1109, 1112, 1114, 1113, 1114, 1113, 1114, 1113, 1113, 1114,
	      1114, 1115, 1116, 1117, 1117, 1119, 1124, 1125, 1127, 1130,
	      1131, 1132, 1132, 1133, 1137, 1138, 1139, 1143, 1143, 1144,
	      1145, 1146, 1148, 1149, 1150, 1150, 1148, 1147, 1146, 1146,
	      1145, 1145, 1146, 1147, 1150, 1152, 1153, 1155, 1156, 1156,
	      1158, 1158, 1160, 1160, 1159, 1160, 1161, 1165, 1165, 1164,
	      1164, 1165, 1165, 1167, 1168, 1168, 1167, 1167, 1168, 1169,
	      1170, 1172, 1174, 1174, 1175, 1176, 1178, 1179, 1180, 1180,
	      1181, 1182, 1184, 1186, 1191, 1192, 1194, 1195, 1197, 1197,
	      1198, 1199, 1199, 1200, 1202, 1208, 1212, 1212, 1214, 1216,
	      1219, 1223, 1223, 1224, 1225, 1228, 1229, 1229, 1230, 1234,
	      1234, 1235, 1237, 1239, 1241, 1242, 1242, 1243, 1243, 1242,
	      1244, 1243, 1243, 1244, 1244, 1244, 1245, 1245, 1244, 1244,
	      1246, 1248, 1250, 1252, 1252, 1253, 1253, 1252, 1252, 1251,
	      1251, 1252, 1253, 1253, 1254, 1254, 1256, 1259, 1263, 1265,
	      1265, 1262, 1262, 1263, 1264, 1264, 1265, 1265, 1266, 1267,
	      1267, 1269, 1270, 1271, 1272, 1274, 1276, 1278, 1279, 1279,
	      1278, 1277, 1276, 1275, 1276, 1275, 1273, 1273, 1274, 1279,
	      1282, 1284, 1285, 1287, 1288, 1287, 1286, 1286, 1285, 1285,
	      1286, 1288, 1290, 1290, 1291, 1292, 1292, 1293, 1293, 1294,
	      1296, 1299, 1301, 1302, 1303, 1301, 1300, 1299, 1301, 1303,
	      1304, 1306, 1307, 1310, 1312, 1313, 1314, 1315, 1315, 1312,
	      1310, 1307, 1307, 1305, 1305, 1306, 1303, 1303, 1301, 1300,
	      1302, 1304, 1303, 1301, 1299, 1294, 1294, 1293, 1293, 1291,
	      1285, 1284, 1287, 1291, 1291, 1294, 1295, 1294, 1294, 1292,
	      1290, 1290, 1286, 1286, 1283, 1281, 1281, 1280, 1279, 1279,
	      1278, 1277, 1274, 1272, 1271, 1270, 1268, 1267, 1267, 1266,
	      1263, 1262, 1258, 1260, 1259, 1260, 1261, 1259, 1259, 1257,
	      1257, 1256, 1257, 1257, 1261, 1264, 1265, 1266, 1267, 1267,
	      1266, 1266, 1265, 1265, 1264, 1261, 1261, 1257, 1252, 1251,
	      1248, 1242, 1240, 1237, 1237, 1240, 1243, 1244, 1244, 1245,
	      1246, 1248, 1250, 1251, 1253, 1257, 1267, 1275, 1278, 1281,
	      1281, 1283, 1286, 1286, 1287, 1287, 1290, 1291, 1292, 1293,
	      1294, 1296, 1299, 1301, 1303, 1306, 1307, 1309, 1313, 1314,
	      1317, 1320, 1322, 1323, 1324, 1324, 1326, 1327, 1330, 1333,
	      1334, 1335, 1338, 1344, 1347, 1351, 1367),
	  y = c(1744, 1743, 1744, 1743, 1742, 1743, 1741, 1742, 1740, 1740,
	      1739, 1739, 1738, 1738, 1737, 1734, 1734, 1731, 1730, 1728,
	      1726, 1724, 1724, 1725, 1725, 1726, 1726, 1724, 1725, 1727,
	      1728, 1729, 1730, 1736, 1738, 1741, 1742, 1745, 1746, 1747,
	      1747, 1748, 1749, 1748, 1748, 1747, 1747, 1750, 1752, 1755,
	      1755, 1756, 1759, 1759, 1760, 1761, 1760, 1760, 1761, 1761,
	      1763, 1763, 1764, 1764, 1766, 1773, 1776, 1779, 1780, 1785,
	      1787, 1788, 1789, 1790, 1787, 1785, 1784, 1783, 1783, 1787,
	      1788, 1788, 1789, 1791, 1792, 1794, 1796, 1797, 1798, 1798,
	      1800, 1800, 1802, 1803, 1804, 1807, 1808, 1810, 1811, 1813,
	      1813, 1815, 1815, 1816, 1815, 1814, 1812, 1810, 1810, 1811,
	      1811, 1813, 1813, 1814, 1816, 1816, 1817, 1817, 1818, 1821,
	      1824, 1826, 1830, 1839, 1841, 1845, 1847, 1850, 1852, 1854,
	      1857, 1857, 1856, 1856, 1858, 1858, 1857, 1856, 1856, 1858,
	      1859, 1860, 1860, 1862, 1866, 1867, 1869, 1871, 1871, 1872,
	      1873, 1873, 1871, 1871, 1869, 1867, 1865, 1864, 1863, 1863,
	      1861, 1861, 1860, 1858, 1857, 1858, 1859, 1859, 1857, 1857,
	      1858, 1859, 1862, 1863, 1865, 1865, 1867, 1866, 1865, 1866,
	      1868, 1869, 1870, 1871, 1871, 1874, 1875, 1876, 1876, 1877,
	      1878, 1880, 1882, 1883, 1884, 1884, 1882, 1882, 1883, 1884,
	      1887, 1889, 1890, 1889, 1889, 1886, 1886, 1882, 1880, 1879,
	      1878, 1877, 1877, 1876, 1876, 1878, 1878, 1879, 1879, 1880,
	      1881, 1881, 1880, 1878, 1877, 1875, 1873, 1873, 1872, 1873,
	      1875, 1877, 1878, 1880, 1882, 1884, 1884, 1883, 1882, 1880,
	      1878, 1880, 1882, 1882, 1881, 1881, 1883, 1885, 1886, 1888,
	      1888, 1885, 1886, 1888, 1889, 1890, 1891, 1891, 1891, 1892,
	      1894, 1895, 1897, 1899, 1902, 1903, 1905, 1908, 1911, 1914,
	      1917, 1917, 1919, 1920, 1920, 1918, 1917, 1918, 1920, 1922,
	      1925, 1928, 1928, 1929, 1931, 1933, 1933, 1935, 1935, 1934,
	      1934, 1938, 1938, 1937, 1936, 1933, 1931, 1927, 1925, 1925,
	      1924, 1923, 1923, 1925, 1927, 1928, 1937, 1938, 1937, 1935,
	      1936, 1937, 1937, 1938, 1938, 1936, 1936, 1934, 1934, 1931,
	      1929, 1928, 1928, 1927, 1927, 1932, 1934, 1933, 1933, 1932,
	      1932, 1934, 1936, 1938, 1940, 1941, 1942, 1942, 1943, 1942,
	      1942, 1940, 1939, 1938, 1937, 1936, 1935, 1933, 1932, 1931,
	      1929, 1928, 1924, 1923, 1919, 1919, 1918, 1917, 1917, 1918,
	      1918, 1919, 1921, 1922, 1922, 1924, 1925, 1927, 1928, 1928,
	      1925, 1922, 1921, 1919, 1918, 1918, 1917, 1916, 1914, 1913,
	      1912, 1909, 1909, 1908, 1908, 1908, 1909, 1909, 1908, 1909,
	      1908, 1909, 1908, 1908, 1909, 1907, 1907, 1906, 1907, 1907,
	      1906, 1906, 1901, 1900, 1903, 1905, 1906, 1908, 1909, 1909,
	      1910, 1909, 1907, 1905, 1905, 1904, 1902, 1902, 1901, 1900,
	      1900, 1899, 1898, 1898, 1899, 1898, 1899, 1899, 1898, 1899,
	      1897, 1898, 1898, 1897, 1897, 1898, 1900, 1900, 1899, 1899,
	      1898, 1898, 1896, 1896, 1895, 1891, 1890, 1888, 1889, 1891,
	      1892, 1893, 1893, 1892, 1891, 1891, 1890, 1889, 1890, 1888,
	      1887, 1885, 1884, 1884, 1886, 1887, 1887, 1888, 1888, 1889,
	      1889, 1888, 1887, 1885, 1884, 1883, 1881, 1880, 1880, 1878,
	      1879, 1879, 1883, 1883, 1884, 1884, 1885, 1886, 1886, 1890,
	      1891, 1890, 1890, 1888, 1887, 1887, 1886, 1886, 1887, 1886,
	      1886, 1885, 1886, 1886, 1885, 1884, 1885, 1884, 1884, 1887,
	      1888, 1888, 1889, 1889, 1890, 1890, 1887, 1886, 1883, 1881,
	      1877, 1876, 1876, 1877, 1878, 1879, 1881, 1881, 1883, 1883,
	      1879, 1873, 1871, 1870, 1868, 1863, 1862, 1860, 1858, 1858,
	      1865, 1863, 1863, 1861, 1861, 1863, 1863, 1867, 1867, 1868,
	      1869, 1869, 1870, 1872, 1877, 1879, 1879, 1882, 1882, 1887,
	      1887, 1889, 1889, 1890, 1890, 1887, 1888, 1887, 1888, 1887,
	      1885, 1884, 1882, 1881, 1881, 1879, 1877, 1875, 1872, 1871,
	      1872, 1872, 1874, 1876, 1877, 1879, 1879, 1881, 1882, 1882,
	      1881, 1881, 1879, 1876, 1875, 1875, 1873, 1872, 1870, 1869,
	      1865, 1861, 1863, 1865, 1867, 1867, 1864, 1862, 1862, 1860,
	      1860, 1858, 1856, 1854, 1851, 1848, 1846, 1845, 1844, 1845,
	      1845, 1844, 1843, 1839, 1838, 1836, 1833, 1832, 1829, 1829,
	      1827, 1824, 1820, 1819, 1818, 1818, 1816, 1816, 1818, 1821,
	      1821, 1819, 1819, 1820, 1822, 1823, 1823, 1821, 1817, 1819,
	      1818, 1819, 1817, 1813, 1812, 1812, 1811, 1807, 1805, 1803,
	      1802, 1800, 1799, 1796, 1798, 1800, 1800, 1798, 1797, 1794,
	      1790, 1791, 1791, 1789, 1785, 1778, 1774, 1771, 1764, 1759,
	      1753, 1745, 1745, 1744, 1739, 1737, 1732, 1732, 1731, 1730,
	      1728, 1726, 1725, 1724, 1723, 1718, 1712, 1708, 1706, 1706,
	      1704, 1699, 1696, 1688, 1687, 1685, 1682, 1677, 1675, 1680,
	      1681, 1682, 1681, 1684, 1684, 1683, 1681, 1681, 1682, 1683,
	      1684, 1684, 1683, 1684, 1683, 1682, 1681, 1679, 1675, 1673,
	      1673, 1671, 1669, 1667, 1665, 1663, 1663)),
     list(x = c(1367, 1368, 1368, 1371, 1372, 1373, 1375, 1376, 1378, 1380,
	      1381, 1383, 1385, 1386, 1389, 1390, 1392, 1399, 1401, 1407,
	      1408, 1410, 1411, 1413, 1415, 1417, 1419, 1420, 1422, 1424,
	      1426, 1426, 1427, 1427, 1430, 1430, 1431, 1431, 1432, 1432,
	      1434, 1436, 1436, 1437, 1437, 1438, 1438, 1442, 1443, 1446,
	      1447, 1450, 1451, 1452, 1454, 1455, 1456, 1456, 1457, 1459,
	      1460, 1462, 1462, 1464, 1466, 1468, 1469, 1470, 1473, 1473,
	      1475, 1475, 1477, 1478, 1479, 1481, 1485, 1487, 1488, 1488,
	      1489, 1490, 1492, 1493, 1495, 1497, 1498, 1499, 1501, 1502,
	      1503, 1505, 1507, 1509, 1511, 1511, 1512, 1515, 1515, 1516,
	      1517, 1517, 1518, 1520, 1522, 1522, 1523, 1523, 1524, 1524,
	      1525, 1525, 1524, 1525, 1525, 1528, 1528, 1529, 1531, 1532,
	      1533, 1535, 1536, 1537, 1540, 1541, 1542, 1541, 1541, 1540,
	      1541, 1541, 1542, 1542, 1544, 1544, 1546, 1546, 1548, 1548,
	      1549, 1550, 1552, 1552, 1553, 1553, 1554, 1554, 1555, 1556,
	      1556, 1558, 1560, 1560, 1561, 1561, 1560, 1562, 1563, 1563,
	      1562, 1562, 1560, 1560, 1557, 1557, 1556, 1556, 1557, 1557,
	      1558, 1559, 1559, 1558, 1559, 1559, 1558, 1558, 1557, 1556,
	      1556, 1555, 1555, 1556, 1556, 1557, 1557, 1558, 1558, 1560,
	      1564, 1564, 1563, 1562, 1562, 1560, 1561, 1561, 1565, 1566,
	      1566, 1567, 1569, 1570, 1571, 1572, 1572, 1573, 1573, 1574,
	      1574, 1576, 1578, 1578, 1577, 1577, 1579, 1578, 1577, 1575,
	      1574, 1574, 1572, 1572, 1575, 1573, 1572, 1569, 1567, 1567,
	      1565, 1562, 1560, 1560, 1561, 1561, 1562, 1563, 1563, 1562,
	      1562, 1563, 1563, 1562, 1564, 1565, 1566, 1566, 1567, 1568,
	      1568, 1569, 1573, 1574, 1575, 1576, 1577, 1577, 1579, 1579,
	      1580, 1582, 1583, 1582, 1581, 1580, 1579, 1579, 1576, 1577,
	      1579, 1579, 1580, 1580, 1581, 1581, 1582, 1582, 1581, 1581,
	      1580, 1581, 1582, 1582, 1583, 1586, 1587, 1587, 1590, 1614,
	      1614, 1617, 1617, 1618, 1618, 1619, 1619, 1621, 1621, 1620,
	      1620, 1621, 1621, 1622, 1623, 1623, 1625, 1626, 1626, 1627,
	      1628, 1630, 1631, 1635, 1637, 1638, 1639, 1640, 1640, 1638,
	      1637, 1636, 1635, 1635, 1634, 1634, 1635, 1635, 1637, 1638,
	      1640, 1642, 1643, 1644, 1644, 1650, 1651, 1652, 1652, 1651,
	      1650, 1650, 1651, 1651, 1652, 1654, 1657, 1658, 1658, 1657,
	      1656, 1656, 1658, 1658, 1659, 1659, 1660, 1662, 1662, 1661,
	      1661, 1662, 1662, 1663, 1664, 1665, 1665, 1666, 1667, 1667,
	      1669, 1669, 1670, 1670, 1671, 1671, 1672, 1674, 1676, 1685,
	      1686, 1687, 1690, 1692, 1692, 1693, 1694, 1702, 1703, 1704,
	      1706, 1707, 1708, 1710, 1712, 1713, 1713, 1715, 1717, 1716,
	      1716, 1718, 1719, 1719, 1721, 1722, 1756, 1759, 1760, 1762,
	      1763, 1753, 1756, 1754, 1753, 1753, 1754, 1756, 1757, 1755,
	      1753, 1752, 1752, 1753, 1753, 1752, 1752, 1753, 1755, 1756,
	      1758, 1756, 1756, 1755, 1754, 1754, 1752, 1752, 1753, 1752,
	      1752, 1753, 1753, 1754, 1754, 1755, 1756, 1756, 1757, 1757,
	      1756, 1756, 1758, 1760, 1761, 1762, 1762, 1761, 1761, 1760,
	      1760, 1761, 1760, 1762, 1763, 1766, 1768, 1768, 1770, 1771,
	      1771, 1776, 1778, 1778, 1779, 1779, 1780, 1780, 1787, 1787,
	      1786, 1786, 1785, 1784, 1787, 1787, 1788, 1788, 1789, 1790,
	      1790, 1791, 1792, 1792, 1794, 1794, 1795, 1795, 1796, 1796,
	      1795, 1797, 1797, 1796, 1796, 1795, 1794, 1793, 1793, 1792,
	      1792, 1803, 1804, 1804, 1805, 1808, 1808, 1807, 1807, 1806,
	      1805, 1805, 1806, 1807, 1807, 1809, 1810, 1812, 1813, 1817,
	      1819, 1820, 1823, 1825, 1827, 1829, 1830, 1830, 1832, 1833,
	      1839, 1840, 1841, 1841, 1843, 1844, 1845, 1846, 1845, 1844,
	      1844, 1847, 1847, 1848, 1850, 1851, 1852, 1854, 1855, 1858,
	      1859, 1862, 1863, 1862, 1862, 1863, 1863, 1864, 1865, 1865,
	      1866, 1868, 1868, 1869, 1869, 1871, 1872, 1872, 1873, 1871,
	      1871, 1872, 1874, 1876, 1878, 1880, 1882, 1883, 1883, 1882,
	      1880, 1882, 1882, 1881, 1882, 1883, 1887, 1887, 1888, 1892,
	      1894, 1896, 1898, 1899, 1900, 1900, 1901, 1903, 1904, 1906,
	      1907, 1908, 1908, 1910, 1910, 1914, 1915, 1916, 1918, 1919,
	      1919, 1918, 1918, 1922, 1922, 1923, 1924, 1924, 1925, 1925,
	      1926, 1926, 1928, 1929, 1930, 1931, 1932, 1932, 1933, 1934,
	      1934, 1936, 1938, 1938, 1937, 1937, 1938, 1938, 1939, 1940,
	      1940, 1942, 1942, 1944, 1945, 1946, 1946, 1944, 1943, 1943,
	      1942, 1941, 1939, 1933, 1932, 1931, 1931, 1930, 1930, 1931,
	      1932, 1932, 1935, 1935, 1937, 1937, 1939, 1940, 1940, 1941,
	      1942, 1943, 1945, 1945, 1947, 1948, 1950, 1951, 1951, 1950,
	      1950, 1956, 1957, 1958, 1960, 1960, 1959, 1959, 1960, 1960,
	      1963, 1963, 1966, 1965, 1965, 1964, 1964, 1968, 1970, 1970,
	      1971, 1971, 1970, 1970, 1971, 1971, 1972, 1972, 1973, 1974,
	      1974, 1975, 1975, 1976, 1976, 1977, 1977, 1976, 1980, 1982,
	      1982, 1984, 1985, 1985, 1988, 1988, 1989, 1989, 1990, 1991,
	      1994, 1994, 1995, 1995, 1997, 1997, 1999, 2000, 2000, 1997,
	      1997, 1998, 1998, 2001, 2003, 2005, 2005, 2006, 2006, 2007,
	      2007, 2009, 2011, 2012, 2021, 2022, 2024, 2027, 2029, 2029,
	      2028, 2028, 2029, 2029, 2028, 2028, 2027, 2026, 2026, 2025,
	      2031, 2031, 2032, 2034, 2034, 2035, 2035, 2033, 2033, 2034,
	      2034, 2035, 2035, 2038, 2038, 2039, 2039, 2040, 2039, 2040,
	      2039, 2039, 2038, 2037, 2037, 2038, 2038, 2040, 2040, 2041,
	      2042, 2043, 2043, 2041, 2041, 2040, 2039, 2040, 2041, 2044,
	      2044, 2048, 2048, 2049, 2050, 2050, 2051, 2053, 2055, 2057,
	      2058, 2059, 2059, 2062, 2064, 2066, 2073, 2075, 2077, 2078,
	      2080, 2081, 2082, 2082, 2081, 2083, 2086, 2086, 2087, 2086,
	      2090, 2090, 2092, 2098, 2099, 2100, 2101, 2101, 2102, 2102,
	      2103, 2103, 2106, 2108, 2113, 2112, 2112, 2114, 2117, 2118,
	      2121, 2122, 2125, 2126, 2128, 2130, 2132, 2133, 2134, 2134,
	      2133, 2132, 2136, 2140, 2143, 2144, 2145, 2147, 2149, 2150,
	      2150, 2151, 2150, 2150, 2151, 2152, 2154, 2156, 2158, 2159,
	      2160, 2160, 2163, 2163, 2159, 2159, 2161, 2161, 2162, 2163,
	      2164, 2164, 2163, 2163, 2162, 2162, 2160, 2159, 2159, 2160,
	      2160, 2162, 2163, 2171, 2173, 2173, 2178, 2179, 2179, 2178,
	      2178, 2177, 2177, 2178, 2178, 2180, 2181),
	  y = c(1663, 1662, 1660, 1657, 1657, 1656, 1656, 1655, 1655, 1653,
	      1653, 1652, 1652, 1651, 1650, 1650, 1648, 1648, 1647, 1647,
	      1646, 1646, 1645, 1645, 1644, 1644, 1643, 1643, 1642, 1640,
	      1640, 1639, 1638, 1637, 1637, 1636, 1635, 1634, 1633, 1632,
	      1631, 1628, 1627, 1627, 1620, 1619, 1618, 1616, 1615, 1615,
	      1614, 1615, 1614, 1612, 1611, 1610, 1610, 1609, 1608, 1607,
	      1607, 1605, 1604, 1604, 1604, 1603, 1604, 1604, 1601, 1600,
	      1599, 1598, 1597, 1597, 1596, 1597, 1597, 1598, 1599, 1598,
	      1598, 1597, 1598, 1599, 1599, 1600, 1600, 1601, 1602, 1602,
	      1603, 1603, 1605, 1605, 1607, 1608, 1607, 1607, 1608, 1610,
	      1611, 1610, 1610, 1609, 1611, 1616, 1618, 1623, 1624, 1628,
	      1629, 1632, 1633, 1634, 1635, 1638, 1639, 1639, 1643, 1644,
	      1646, 1648, 1650, 1651, 1657, 1658, 1660, 1661, 1663, 1664,
	      1665, 1667, 1668, 1669, 1671, 1675, 1678, 1681, 1683, 1686,
	      1687, 1687, 1689, 1699, 1700, 1705, 1707, 1711, 1712, 1715,
	      1716, 1718, 1723, 1725, 1727, 1729, 1730, 1731, 1733, 1735,
	      1738, 1743, 1745, 1751, 1758, 1764, 1766, 1767, 1769, 1772,
	      1773, 1775, 1778, 1780, 1783, 1784, 1785, 1786, 1787, 1789,
	      1792, 1794, 1801, 1803, 1809, 1811, 1814, 1815, 1816, 1821,
	      1825, 1830, 1831, 1831, 1837, 1839, 1841, 1842, 1846, 1848,
	      1851, 1853, 1855, 1854, 1854, 1853, 1852, 1850, 1849, 1848,
	      1847, 1845, 1845, 1847, 1848, 1851, 1853, 1854, 1853, 1853,
	      1854, 1856, 1857, 1860, 1863, 1863, 1862, 1862, 1863, 1864,
	      1864, 1861, 1861, 1862, 1864, 1865, 1867, 1867, 1869, 1870,
	      1871, 1872, 1876, 1879, 1881, 1881, 1882, 1887, 1889, 1890,
	      1891, 1891, 1895, 1895, 1894, 1892, 1891, 1890, 1892, 1893,
	      1894, 1894, 1895, 1895, 1896, 1896, 1897, 1899, 1902, 1904,
	      1905, 1908, 1910, 1912, 1912, 1917, 1918, 1938, 1939, 1941,
	      1942, 1942, 1943, 1944, 1944, 1947, 1947, 1948, 1949, 1944,
	      1943, 1940, 1939, 1938, 1936, 1934, 1928, 1926, 1920, 1919,
	      1916, 1914, 1912, 1908, 1908, 1905, 1900, 1899, 1898, 1898,
	      1897, 1897, 1896, 1898, 1898, 1897, 1897, 1896, 1893, 1891,
	      1889, 1889, 1887, 1886, 1885, 1883, 1882, 1878, 1877, 1877,
	      1875, 1874, 1872, 1871, 1868, 1862, 1860, 1860, 1859, 1858,
	      1856, 1847, 1847, 1848, 1849, 1850, 1850, 1848, 1844, 1843,
	      1841, 1835, 1833, 1822, 1821, 1820, 1819, 1815, 1813, 1811,
	      1801, 1799, 1795, 1792, 1791, 1788, 1787, 1786, 1784, 1783,
	      1778, 1777, 1775, 1772, 1772, 1771, 1771, 1769, 1766, 1766,
	      1767, 1769, 1769, 1770, 1773, 1776, 1777, 1777, 1778, 1778,
	      1779, 1780, 1780, 1779, 1777, 1775, 1772, 1772, 1770, 1769,
	      1766, 1763, 1763, 1762, 1761, 1760, 1760, 1758, 1756, 1756,
	      1755, 1746, 1746, 1745, 1744, 1743, 1742, 1742, 1741, 1736,
	      1734, 1732, 1731, 1729, 1728, 1728, 1726, 1725, 1725, 1726,
	      1726, 1725, 1724, 1723, 1720, 1719, 1718, 1715, 1714, 1713,
	      1711, 1711, 1709, 1708, 1705, 1700, 1698, 1694, 1693, 1692,
	      1690, 1688, 1688, 1687, 1686, 1684, 1671, 1671, 1670, 1669,
	      1666, 1665, 1665, 1663, 1660, 1657, 1654, 1653, 1651, 1651,
	      1650, 1645, 1644, 1642, 1641, 1640, 1640, 1641, 1641, 1640,
	      1639, 1635, 1634, 1632, 1629, 1627, 1626, 1624, 1623, 1621,
	      1619, 1617, 1616, 1614, 1612, 1608, 1607, 1605, 1604, 1600,
	      1600, 1595, 1594, 1592, 1585, 1583, 1575, 1572, 1571, 1569,
	      1568, 1557, 1557, 1556, 1555, 1555, 1552, 1551, 1548, 1547,
	      1545, 1540, 1539, 1537, 1536, 1533, 1530, 1528, 1528, 1524,
	      1523, 1522, 1522, 1520, 1520, 1522, 1522, 1517, 1516, 1516,
	      1514, 1515, 1515, 1518, 1520, 1520, 1518, 1517, 1517, 1516,
	      1514, 1514, 1511, 1511, 1509, 1509, 1508, 1508, 1507, 1507,
	      1508, 1508, 1509, 1510, 1511, 1513, 1515, 1514, 1512, 1511,
	      1509, 1508, 1507, 1506, 1505, 1501, 1500, 1499, 1498, 1497,
	      1495, 1494, 1493, 1489, 1486, 1486, 1485, 1487, 1490, 1490,
	      1491, 1491, 1492, 1493, 1494, 1494, 1490, 1489, 1487, 1483,
	      1483, 1485, 1485, 1484, 1484, 1482, 1482, 1481, 1480, 1479,
	      1478, 1478, 1477, 1477, 1472, 1470, 1470, 1469, 1470, 1470,
	      1472, 1473, 1474, 1474, 1475, 1475, 1474, 1471, 1470, 1469,
	      1469, 1468, 1467, 1467, 1466, 1466, 1464, 1463, 1462, 1462,
	      1464, 1464, 1463, 1462, 1461, 1460, 1459, 1457, 1456, 1456,
	      1455, 1453, 1452, 1450, 1448, 1447, 1446, 1447, 1447, 1448,
	      1449, 1451, 1453, 1453, 1454, 1454, 1452, 1449, 1445, 1443,
	      1443, 1442, 1439, 1438, 1436, 1434, 1433, 1432, 1430, 1429,
	      1429, 1430, 1430, 1431, 1431, 1430, 1429, 1429, 1428, 1427,
	      1424, 1424, 1423, 1421, 1420, 1419, 1418, 1412, 1411, 1410,
	      1410, 1408, 1404, 1403, 1402, 1400, 1397, 1397, 1394, 1393,
	      1393, 1390, 1389, 1384, 1383, 1379, 1377, 1374, 1372, 1371,
	      1368, 1366, 1364, 1363, 1357, 1357, 1355, 1353, 1353, 1352,
	      1350, 1348, 1348, 1345, 1345, 1346, 1347, 1348, 1350, 1350,
	      1347, 1345, 1343, 1341, 1339, 1338, 1338, 1339, 1343, 1351,
	      1354, 1356, 1359, 1356, 1355, 1353, 1352, 1351, 1350, 1350,
	      1349, 1347, 1346, 1345, 1341, 1341, 1339, 1339, 1340, 1342,
	      1344, 1346, 1345, 1346, 1345, 1346, 1346, 1347, 1348, 1349,
	      1349, 1348, 1348, 1346, 1345, 1345, 1343, 1341, 1339, 1338,
	      1337, 1336, 1337, 1337, 1338, 1336, 1333, 1331, 1328, 1326,
	      1324, 1319, 1317, 1316, 1314, 1313, 1305, 1301, 1295, 1293,
	      1293, 1292, 1289, 1287, 1286, 1286, 1285, 1285, 1284, 1284,
	      1285, 1285, 1284, 1284, 1283, 1282, 1281, 1281, 1278, 1276,
	      1276, 1275, 1274, 1271, 1270, 1267, 1264, 1262, 1262, 1261,
	      1262, 1261, 1261, 1262, 1264, 1265, 1265, 1264, 1265, 1265,
	      1261, 1259, 1258, 1252, 1252, 1251, 1249, 1247, 1244, 1241,
	      1239, 1237, 1235, 1232, 1230, 1231, 1230, 1229, 1226, 1223,
	      1222, 1219, 1218, 1215, 1213, 1208, 1207, 1204, 1204, 1202,
	      1202, 1200, 1198, 1197, 1197, 1198, 1197, 1197, 1195, 1192,
	      1187, 1186, 1183, 1177, 1174, 1173, 1168, 1166, 1165, 1164,
	      1164, 1162, 1156, 1155, 1145, 1131, 1127, 1123, 1122, 1119,
	      1118, 1114, 1113, 1111, 1108, 1098, 1093, 1093, 1092, 1089,
	      1087, 1086, 1084, 1076, 1072, 1070, 1057, 1057, 1058, 1058,
	      1059, 1060, 1058, 1055, 1054, 1050, 1044)),
     list(x = c(2181, 2181, 2182, 2182, 2184, 2184, 2185, 2185, 2186, 2187,
	      2188, 2186, 2186, 2189, 2191, 2191, 2190, 2190, 2188, 2186,
	      2184, 2184, 2182, 2182, 2181, 2180, 2178, 2176, 2176, 2174,
	      2174, 2175, 2174, 2173, 2174, 2174, 2173, 2173, 2170, 2171,
	      2170, 2169, 2169, 2168, 2168, 2167, 2168, 2168, 2167, 2166,
	      2166, 2164, 2164, 2162, 2160, 2159, 2160, 2159, 2159, 2157,
	      2156, 2156, 2157, 2157, 2158, 2160, 2160, 2159, 2159, 2160,
	      2159, 2159, 2158, 2158, 2157, 2157, 2156, 2154, 2153, 2153,
	      2151, 2151, 2148, 2148, 2147, 2146, 2145, 2145, 2144, 2143,
	      2142, 2142, 2141, 2138, 2136, 2132, 2131, 2131, 2130, 2130,
	      2131, 2132, 2132, 2131, 2129, 2127, 2125, 2123, 2122, 2121,
	      2119, 2119, 2118, 2118, 2117, 2117, 2116, 2114, 2109, 2108,
	      2104, 2104, 2105, 2106, 2107, 2108, 2109, 2110, 2111, 2112,
	      2113, 2113, 2112, 2111, 2101, 2101, 2099, 2099, 2098, 2098,
	      2096, 2095, 2095, 2096, 2096, 2094, 2094, 2093, 2093, 2094,
	      2094, 2093, 2093, 2092, 2091, 2091, 2090, 2090, 2086, 2086,
	      2085, 2084, 2084, 2083, 2083, 2082, 2082, 2083, 2086, 2086,
	      2085, 2085, 2084, 2084, 2083, 2082, 2083, 2083, 2082, 2081,
	      2080, 2078, 2078, 2079, 2080, 2080, 2081, 2081, 2080, 2080,
	      2079, 2079, 2078, 2077, 2077, 2076, 2076, 2074, 2072, 2072,
	      2071, 2071, 2070, 2070, 2071, 2071, 2070, 2070, 2069, 2069,
	      2068, 2068, 2065, 2064, 2063, 2065, 2065, 2066, 2068, 2068,
	      2066, 2066, 2063, 2063, 2062, 2061, 2061, 2058, 2059, 2063,
	      2063, 2061, 2061, 2060, 2060, 2061, 2060, 2058, 2057, 2056,
	      2054, 2054, 2053, 2053, 2052, 2051, 2051, 2050, 2049, 2050,
	      2050, 2048, 2046, 2044, 2044, 2047, 2047, 2046, 2046, 2045,
	      2046, 2046, 2045, 2045, 2044, 2044, 2043, 2043, 2041, 2042,
	      2043, 2043, 2042, 2043, 2043, 2042, 2041, 2039, 2038, 2037,
	      2038, 2037, 2037, 2038, 2037, 2039, 2040, 2041, 2042, 2042,
	      2036, 2034, 2033, 2033, 2032, 2032, 2029, 2029, 2028, 2027,
	      2025, 2025, 2026, 2026, 2025, 2025, 2024, 2024, 2022, 2022,
	      2023, 2022, 2022, 2021, 2016, 2016, 2014, 2010, 2008, 2006,
	      2007, 2009, 2010, 2011, 2011, 2009, 2008, 2007, 2008, 2010,
	      2009, 2009, 2007, 2006, 2006, 2007, 2008, 2008, 2007, 2006,
	      2007, 2005, 2006, 2006, 2005, 2006, 2005, 2004, 2003, 2003,
	      2004, 2003, 2003, 2002, 2002, 2001, 2001, 2000, 1999, 1999,
	      1998, 1998, 1996, 1996, 1995, 1995, 1996, 1997, 1997, 1996,
	      1996, 1998, 2000, 2001, 2001, 2002, 2002, 2000, 1999, 2000,
	      2000, 1999, 2000, 1999, 1999, 1997, 1995, 1991, 1990, 1989,
	      1986, 1985, 1984, 1983, 1984, 1980),
	  y = c(1044, 1047, 1046, 1044, 1042, 1041, 1040, 1039, 1037, 1036,
	      1034, 1029, 1021, 1020, 1018, 1017, 1014, 1006, 1002, 1001,
	      997, 994, 992, 990, 989, 986, 985, 983, 981, 976, 974, 974,
	      975, 976, 972, 961, 958, 955, 949, 948, 946, 945, 944, 943,
	      942, 941, 940, 935, 933, 932, 931, 929, 930, 928, 924, 923,
	      921, 919, 916, 916, 913, 912, 909, 897, 897, 895, 896, 896,
	      894, 893, 892, 887, 886, 884, 883, 881, 880, 874, 873, 871,
	      866, 865, 859, 856, 855, 853, 852, 849, 848, 846, 845, 844,
	      842, 839, 838, 835, 835, 833, 832, 824, 823, 820, 817, 819,
	      819, 818, 816, 815, 814, 812, 812, 811, 811, 810, 810, 809,
	      809, 810, 810, 811, 811, 808, 807, 808, 807, 808, 808, 807,
	      807, 806, 806, 804, 804, 803, 803, 802, 802, 801, 801, 800,
	      800, 800, 802, 803, 802, 802, 801, 801, 800, 800, 795, 794,
	      792, 791, 791, 790, 790, 789, 789, 792, 792, 790, 789, 789,
	      788, 787, 786, 787, 787, 784, 782, 781, 780, 779, 778, 779,
	      780, 781, 781, 780, 780, 778, 776, 777, 777, 775, 775, 774,
	      774, 772, 771, 770, 769, 769, 768, 767, 765, 765, 767, 766,
	      767, 765, 765, 763, 761, 760, 759, 755, 754, 752, 751, 750,
	      747, 747, 746, 746, 745, 745, 743, 740, 740, 741, 741, 738,
	      738, 737, 738, 737, 736, 736, 734, 733, 732, 733, 732, 733,
	      734, 733, 733, 731, 731, 729, 729, 728, 727, 725, 723, 721,
	      720, 719, 717, 715, 714, 714, 713, 713, 710, 709, 707, 707,
	      705, 702, 701, 700, 699, 698, 697, 696, 694, 692, 691, 690,
	      689, 688, 687, 687, 686, 688, 687, 687, 687, 686, 687, 686,
	      685, 685, 684, 684, 683, 681, 681, 682, 683, 684, 684, 681,
	      678, 677, 677, 676, 676, 674, 673, 671, 669, 667, 666, 665,
	      664, 663, 663, 661, 660, 660, 655, 651, 651, 653, 653, 654,
	      651, 651, 649, 648, 646, 644, 644, 642, 642, 640, 638, 635,
	      636, 635, 632, 632, 632, 633, 633, 632, 632, 630, 629, 622,
	      621, 619, 619, 617, 616, 614, 613, 611, 608, 606, 603, 602,
	      599, 598, 596, 592, 591, 590, 589, 588, 588, 587, 585, 585,
	      580, 579, 578, 578, 574, 573, 572, 571, 569, 569, 566, 565,
	      559, 558, 556, 556, 554, 554, 555, 555, 557, 558, 558, 559,
	      559, 557, 556, 556)),
     list(x = c(1980, 1984, 1986, 1987, 1986, 1984, 1983, 1983, 1983, 1982,
	      1982, 1981, 1979, 1975, 1974, 1972, 1964, 1961, 1957, 1952,
	      1947, 1946, 1945, 1945, 1946, 1946, 1944, 1942, 1923, 1922,
	      1919, 1915, 1913, 1911, 1907, 1906, 1901, 1901, 1899, 1898,
	      1897, 1896, 1896, 1897, 1896, 1896, 1895, 1893, 1886, 1885,
	      1879, 1878, 1879, 1880, 1880, 1879, 1877, 1875, 1873, 1872,
	      1870, 1869, 1866, 1864, 1863, 1861, 1858, 1857, 1855, 1855,
	      1857, 1859, 1863, 1864, 1867, 1869, 1870, 1871, 1875, 1877,
	      1878, 1879, 1882, 1884, 1884, 1886, 1887, 1895, 1895, 1891,
	      1889, 1887, 1880, 1878, 1876, 1876, 1870, 1869, 1867, 1866,
	      1864, 1861, 1856, 1853, 1851, 1849, 1847, 1844, 1842, 1840,
	      1837, 1835, 1835, 1832, 1830, 1829, 1827, 1826, 1826, 1818,
	      1816, 1814, 1813, 1812, 1810, 1809, 1807, 1805, 1802, 1801,
	      1801, 1800, 1801, 1802, 1803, 1804, 1803, 1804, 1804, 1805,
	      1810, 1811, 1811, 1813, 1813, 1814, 1815, 1814, 1814, 1813,
	      1813, 1814, 1813, 1814, 1813, 1813, 1812, 1812, 1810, 1808,
	      1806, 1802, 1801, 1800, 1800, 1799, 1797, 1797, 1796, 1796,
	      1795, 1793, 1792, 1791, 1790, 1790, 1789, 1788, 1787, 1786,
	      1785, 1783, 1782, 1781, 1779, 1778, 1778, 1779, 1779, 1778,
	      1778, 1779, 1778, 1779, 1778, 1778, 1776, 1775, 1772, 1771,
	      1769, 1767, 1763, 1762, 1761, 1760, 1759, 1759, 1763, 1764,
	      1764, 1765, 1766, 1768, 1768, 1766, 1765, 1765, 1763, 1763,
	      1761, 1760, 1759, 1755, 1753, 1752, 1750, 1749, 1747, 1747,
	      1746, 1743, 1742, 1740, 1739, 1736, 1735, 1736, 1734, 1732,
	      1728, 1726, 1724, 1722, 1721, 1721, 1727, 1731, 1734, 1736,
	      1736, 1737, 1737, 1739, 1740, 1741, 1740, 1741, 1742, 1742,
	      1743, 1743, 1744, 1744, 1742, 1740, 1739, 1736, 1735, 1735,
	      1734, 1732, 1732, 1731, 1730, 1728, 1724, 1723, 1722, 1720,
	      1719, 1714, 1707, 1704, 1705, 1707, 1712, 1721, 1721, 1722,
	      1722, 1721, 1720, 1720, 1721, 1721, 1720, 1718, 1716, 1711,
	      1709, 1706, 1705, 1701, 1702, 1701, 1700, 1698, 1693, 1692,
	      1691, 1688, 1687, 1686, 1684, 1680, 1678, 1677, 1675, 1674,
	      1671, 1656, 1654, 1653, 1652, 1651, 1650, 1649, 1648, 1646,
	      1644, 1642, 1639, 1636, 1631, 1630, 1627, 1626, 1624, 1623,
	      1621, 1617, 1616, 1613, 1612, 1610, 1604, 1601, 1600, 1599,
	      1597, 1593, 1591, 1588, 1584, 1583, 1577, 1574, 1571, 1570,
	      1564, 1561, 1557, 1557, 1558, 1557, 1558, 1557, 1556, 1554,
	      1552, 1551, 1549, 1548, 1546, 1545, 1543, 1543, 1544, 1543,
	      1543, 1544, 1544, 1537, 1528, 1523, 1522),
	  y = c(556, 556, 552, 552, 550, 550, 548, 549, 550, 550, 549, 549,
	      548, 544, 544, 543, 543, 544, 544, 546, 546, 547, 546, 545,
	      545, 544, 544, 543, 543, 542, 543, 543, 544, 543, 543, 542,
	      542, 544, 543, 543, 544, 543, 541, 541, 540, 539, 539, 541,
	      541, 540, 540, 539, 538, 538, 535, 534, 534, 532, 531, 531,
	      530, 531, 531, 530, 529, 529, 530, 529, 528, 525, 525, 526,
	      527, 528, 528, 529, 530, 530, 532, 532, 533, 533, 536, 536,
	      537, 537, 538, 538, 537, 536, 535, 535, 532, 530, 529, 528,
	      525, 523, 522, 521, 520, 517, 514, 510, 508, 507, 504, 503,
	      501, 500, 497, 497, 498, 498, 496, 496, 494, 494, 493, 493,
	      492, 493, 492, 493, 494, 493, 494, 493, 493, 492, 491, 490,
	      489, 487, 487, 486, 483, 483, 482, 482, 484, 485, 484, 484,
	      483, 483, 482, 481, 477, 476, 474, 474, 473, 472, 472, 471,
	      471, 470, 470, 471, 474, 478, 480, 481, 483, 485, 487, 486,
	      486, 485, 486, 486, 487, 487, 485, 484, 483, 483, 484, 484,
	      486, 488, 491, 492, 496, 496, 498, 498, 499, 499, 498, 498,
	      497, 497, 498, 497, 496, 494, 494, 495, 496, 498, 500, 501,
	      501, 502, 502, 505, 510, 510, 511, 511, 510, 511, 513, 515,
	      517, 518, 518, 519, 519, 520, 519, 519, 520, 519, 518, 516,
	      514, 512, 512, 509, 507, 507, 506, 505, 505, 504, 505, 505,
	      509, 510, 512, 512, 513, 514, 514, 512, 512, 514, 515, 515,
	      516, 518, 518, 519, 520, 522, 521, 522, 523, 524, 525, 531,
	      532, 532, 534, 537, 539, 540, 541, 541, 538, 538, 536, 536,
	      533, 533, 532, 531, 530, 528, 528, 525, 523, 523, 525, 525,
	      523, 522, 521, 519, 519, 517, 517, 515, 514, 514, 515, 515,
	      514, 514, 513, 511, 511, 510, 510, 508, 505, 505, 504, 503,
	      502, 500, 499, 495, 494, 493, 492, 492, 491, 481, 481, 482,
	      484, 484, 485, 485, 486, 486, 485, 485, 488, 490, 492, 493,
	      494, 495, 495, 496, 497, 497, 498, 499, 501, 503, 506, 506,
	      507, 508, 509, 509, 507, 508, 508, 509, 512, 512, 514, 514,
	      516, 516, 514, 512, 511, 511, 510, 509, 507, 508, 508, 509,
	      509, 510, 509, 510, 510, 512, 515, 515, 514, 514, 516, 523,
	      527, 527, 529)),
     list(x = c(1837, 1837, 1836, 1835, 1832, 1831, 1825, 1824, 1823, 1821,
	      1820, 1819, 1818, 1818, 1817, 1816, 1816, 1814, 1812, 1811,
	      1810, 1807, 1807, 1806, 1805, 1803, 1801, 1800, 1799, 1798,
	      1797, 1797, 1796, 1795, 1792, 1792, 1791, 1790, 1789, 1789,
	      1786, 1786, 1787, 1787, 1789, 1790, 1791, 1792, 1795, 1795,
	      1796, 1796, 1797, 1797, 1790, 1789, 1787, 1786, 1784, 1782,
	      1781, 1781, 1780, 1781, 1781, 1782, 1782, 1781, 1780, 1779,
	      1774, 1772, 1772, 1771, 1771, 1770, 1770, 1769, 1767, 1765,
	      1763, 1763, 1762, 1761, 1761, 1760, 1760, 1759, 1759, 1757,
	      1757, 1756, 1756, 1755, 1755, 1752, 1749, 1749, 1750, 1750,
	      1751, 1751, 1750, 1750, 1748, 1748, 1747, 1747, 1746, 1746,
	      1748, 1748, 1749, 1749, 1750, 1750, 1751, 1751, 1752, 1753,
	      1754, 1754, 1757, 1757, 1758, 1758, 1759, 1760, 1760, 1761,
	      1762, 1763, 1763, 1764, 1764, 1765, 1762, 1761, 1759, 1759,
	      1758, 1757, 1757, 1756, 1755, 1755, 1754, 1754, 1753, 1753,
	      1752, 1751, 1751, 1750, 1749, 1749, 1748, 1748, 1747, 1746,
	      1744, 1744, 1741, 1740, 1739, 1739, 1738, 1737, 1735, 1734,
	      1734, 1732, 1732, 1731, 1730, 1730, 1728, 1726, 1724, 1724,
	      1723, 1724, 1724, 1722, 1722, 1721, 1721, 1719, 1719, 1721,
	      1721, 1720, 1719, 1718, 1716, 1716, 1717, 1717, 1718, 1719,
	      1719, 1718, 1718, 1719, 1719, 1721, 1721, 1722, 1723, 1723,
	      1724, 1725, 1726, 1727, 1729, 1730, 1732, 1733, 1734, 1735,
	      1736, 1739, 1739, 1740, 1740, 1741, 1742, 1743, 1748, 1748,
	      1750, 1750, 1751, 1751, 1752, 1753, 1753, 1754, 1755, 1756,
	      1757, 1760, 1761, 1762, 1763, 1764, 1766, 1767, 1768, 1769,
	      1770, 1772, 1773, 1775, 1775, 1777, 1779, 1780, 1782, 1783,
	      1783, 1787, 1788, 1789, 1790, 1794, 1796, 1797, 1797, 1798,
	      1799, 1800, 1801, 1802, 1803, 1804, 1804, 1805, 1806, 1806,
	      1808, 1810, 1812, 1817, 1817, 1818, 1819, 1819, 1821, 1823,
	      1825, 1826, 1828, 1828, 1829, 1829, 1830, 1833, 1834, 1835,
	      1835, 1837, 1838, 1838, 1839, 1839, 1840, 1840, 1841, 1842,
	      1843, 1843, 1845, 1843, 1842, 1841, 1840, 1839, 1839, 1838,
	      1838, 1836, 1835, 1835, 1834, 1831, 1831, 1832, 1832, 1835,
	      1835, 1836, 1840, 1841, 1842, 1843, 1846, 1848, 1849, 1849,
	      1850, 1851, 1852, 1854, 1855, 1864, 1866, 1868, 1871, 1872,
	      1873, 1879, 1883, 1884, 1885, 1886, 1886, 1887, 1888, 1888,
	      1889, 1889, 1890, 1891, 1896, 1897, 1897, 1899, 1900, 1901,
	      1902, 1903, 1904, 1904, 1907, 1906, 1908, 1908, 1909, 1909,
	      1908, 1908, 1907, 1907, 1908, 1908, 1907, 1907, 1908, 1909,
	      1909, 1910, 1910, 1909, 1909, 1908, 1908, 1907, 1905, 1905,
	      1906, 1906, 1907, 1907, 1908, 1908, 1907, 1907, 1908, 1908,
	      1907, 1905, 1905, 1906, 1906, 1909, 1908, 1908, 1909, 1909,
	      1910, 1910, 1911, 1911, 1910, 1910, 1909, 1908, 1908, 1907,
	      1907, 1905, 1905, 1906, 1906, 1905, 1905, 1904, 1903, 1901,
	      1901, 1900, 1901, 1905, 1904, 1899, 1897, 1897, 1896, 1895,
	      1895, 1894, 1894, 1892, 1892, 1891, 1891, 1893, 1893, 1894,
	      1894, 1893, 1893, 1894, 1894, 1891, 1889, 1889, 1888, 1888,
	      1889, 1890, 1891, 1891, 1892, 1892, 1891, 1891, 1890, 1888,
	      1888, 1887, 1887, 1886, 1886, 1887, 1888, 1888, 1889, 1892,
	      1893, 1893, 1892, 1891, 1891, 1894, 1894, 1892, 1891, 1890,
	      1889, 1889, 1888, 1887, 1887, 1886, 1885, 1884, 1883, 1880,
	      1880, 1879, 1879, 1877, 1876, 1875, 1875, 1876, 1878, 1878,
	      1879, 1881, 1881, 1880, 1880, 1881, 1883, 1885, 1886, 1888,
	      1888, 1884, 1884, 1883, 1883, 1882, 1880, 1878, 1876, 1875,
	      1875, 1874, 1872, 1871, 1868, 1867, 1866, 1866, 1867, 1870,
	      1870, 1869, 1868, 1868, 1869, 1869, 1866, 1862, 1862, 1863,
	      1863, 1864, 1865, 1865, 1864, 1865, 1864, 1863, 1862, 1862,
	      1861, 1861, 1860, 1859, 1858, 1858, 1857, 1855, 1855, 1854,
	      1851, 1851, 1853, 1854, 1854, 1856, 1857, 1858, 1858, 1859,
	      1859, 1860, 1861, 1861, 1860, 1860, 1858, 1856, 1856, 1855,
	      1855, 1853, 1852, 1851, 1850, 1848, 1848, 1847, 1846, 1844,
	      1844, 1843, 1843, 1842, 1841, 1841, 1840, 1839, 1839, 1838,
	      1838, 1839, 1839, 1840, 1840, 1841, 1842, 1843, 1844, 1845,
	      1845, 1842, 1841, 1840, 1839, 1843, 1843, 1842, 1841, 1840,
	      1839, 1838, 1838, 1837, 1837, 1838, 1839, 1839, 1838, 1839,
	      1839, 1836, 1836, 1835, 1835, 1836, 1836, 1837, 1837, 1835,
	      1834),
	  y = c(233, 232, 232, 231, 231, 232, 232, 233, 233, 235, 235, 236,
	      236, 237, 238, 238, 239, 239, 237, 237, 236, 236, 237, 237,
	      238, 238, 239, 240, 240, 239, 239, 238, 238, 239, 239, 237,
	      237, 238, 238, 240, 243, 245, 245, 246, 246, 247, 247, 246,
	      246, 245, 245, 244, 244, 248, 248, 249, 249, 250, 251, 253,
	      253, 254, 253, 253, 252, 252, 250, 250, 251, 251, 256, 257,
	      258, 259, 260, 261, 265, 266, 266, 267, 267, 268, 269, 269,
	      272, 272, 274, 275, 276, 276, 280, 280, 282, 282, 283, 286,
	      286, 287, 287, 288, 289, 290, 291, 292, 294, 295, 297, 303,
	      304, 308, 308, 307, 307, 306, 306, 305, 305, 304, 304, 303,
	      303, 302, 302, 301, 301, 300, 300, 299, 297, 296, 297, 297,
	      298, 299, 300, 301, 301, 302, 302, 303, 304, 304, 305, 306,
	      306, 307, 307, 308, 308, 309, 310, 310, 309, 308, 309, 310,
	      311, 317, 318, 320, 321, 322, 325, 325, 327, 328, 328, 329,
	      330, 331, 335, 335, 336, 336, 337, 344, 346, 347, 347, 348,
	      349, 350, 351, 353, 354, 355, 357, 359, 365, 367, 368, 368,
	      369, 369, 370, 373, 374, 375, 375, 376, 380, 381, 383, 384,
	      387, 388, 389, 388, 388, 387, 387, 386, 386, 385, 385, 384,
	      384, 383, 383, 384, 383, 383, 382, 382, 381, 381, 380, 381,
	      381, 386, 386, 384, 383, 382, 382, 381, 380, 380, 379, 379,
	      378, 378, 377, 377, 376, 376, 375, 375, 374, 374, 373, 373,
	      372, 372, 371, 371, 369, 369, 368, 368, 367, 367, 366, 366,
	      365, 365, 363, 363, 362, 362, 363, 363, 362, 362, 363, 363,
	      362, 361, 361, 360, 360, 362, 363, 363, 362, 361, 361, 365,
	      365, 366, 366, 367, 367, 366, 365, 364, 364, 361, 361, 360,
	      359, 357, 357, 355, 355, 354, 354, 353, 353, 352, 352, 351,
	      351, 353, 353, 354, 354, 355, 356, 356, 359, 361, 361, 362,
	      363, 363, 368, 368, 369, 369, 370, 370, 372, 371, 371, 370,
	      370, 369, 369, 370, 370, 371, 371, 373, 372, 372, 373, 373,
	      376, 376, 377, 377, 375, 376, 376, 377, 378, 378, 379, 380,
	      381, 382, 382, 383, 383, 382, 381, 381, 380, 380, 379, 379,
	      378, 377, 374, 373, 371, 370, 369, 368, 368, 365, 365, 361,
	      360, 357, 357, 353, 353, 354, 355, 355, 354, 354, 353, 352,
	      349, 349, 347, 346, 346, 342, 342, 340, 340, 337, 336, 334,
	      334, 332, 332, 330, 328, 327, 326, 323, 322, 319, 319, 317,
	      316, 314, 313, 307, 306, 305, 305, 306, 311, 312, 313, 315,
	      316, 317, 318, 318, 319, 319, 318, 318, 317, 316, 315, 315,
	      314, 314, 313, 310, 310, 309, 307, 307, 306, 304, 303, 303,
	      302, 302, 301, 301, 300, 299, 295, 294, 291, 291, 292, 291,
	      291, 289, 289, 288, 288, 287, 286, 285, 284, 281, 281, 279,
	      278, 277, 276, 275, 274, 273, 273, 274, 274, 271, 271, 269,
	      269, 268, 263, 260, 258, 256, 256, 257, 257, 258, 259, 258,
	      257, 257, 256, 256, 257, 257, 260, 261, 262, 262, 263, 263,
	      267, 267, 269, 270, 269, 269, 268, 267, 266, 266, 264, 264,
	      265, 265, 266, 270, 271, 271, 272, 272, 273, 273, 274, 274,
	      275, 276, 276, 277, 277, 278, 278, 277, 276, 276, 275, 275,
	      274, 273, 272, 268, 265, 265, 267, 267, 266, 267, 267, 268,
	      269, 270, 270, 269, 270, 272, 273, 274, 275, 275, 276, 277,
	      277, 279, 280, 281, 281, 280, 280, 279, 278, 276, 276, 275,
	      274, 274, 273, 272, 272, 270, 270, 266, 265, 265, 254, 253,
	      252, 252, 251, 251, 252, 252, 255, 257, 257, 255, 254, 254,
	      255, 255, 257, 262, 260, 260, 259, 258, 256, 255, 254, 254,
	      253, 253, 252, 252, 251, 251, 249, 249, 248, 248, 247, 247,
	      244, 243, 243, 242, 243, 243, 242, 242, 241, 241, 240, 239,
	      239, 238, 237, 237, 236, 236, 235, 235, 234, 234, 233, 231,
	      231)),
     list(x = c(1522, 1523, 1520, 1515, 1505, 1501, 1497, 1496, 1495, 1495,
	      1493, 1493, 1492, 1492, 1490, 1490, 1489, 1490, 1491, 1491,
	      1493, 1493, 1494, 1492, 1491, 1491, 1490, 1489, 1488, 1488,
	      1482, 1479, 1478, 1478, 1477, 1475, 1473, 1469, 1465, 1459,
	      1460, 1461, 1462, 1461, 1461, 1460, 1460, 1459, 1458, 1459,
	      1460, 1462, 1463, 1464, 1465, 1465, 1466, 1465, 1465, 1464,
	      1464, 1463, 1463, 1459, 1455, 1453, 1447, 1442, 1435, 1431,
	      1429, 1427, 1425, 1425, 1424, 1422, 1422, 1424, 1425, 1425,
	      1424, 1425, 1426, 1428, 1429, 1430, 1430, 1429, 1429, 1434,
	      1420, 1419, 1418, 1417, 1413, 1411, 1411, 1407, 1406, 1400,
	      1398, 1395, 1390, 1382, 1379, 1378, 1378, 1379, 1388, 1390,
	      1395, 1398, 1398, 1399, 1399, 1400, 1400, 1399, 1399, 1398,
	      1398, 1397, 1395, 1396, 1397, 1397, 1394, 1389, 1387, 1385,
	      1383, 1381, 1378, 1376, 1376, 1375, 1372, 1370, 1370, 1369,
	      1367, 1366, 1366, 1364, 1364, 1363, 1360, 1358, 1357, 1357,
	      1355, 1351, 1344, 1337, 1335, 1333, 1331, 1329, 1324, 1318,
	      1317, 1316, 1313, 1313, 1316, 1316, 1317, 1318, 1319, 1320,
	      1324, 1327, 1329, 1331, 1335, 1338, 1341, 1343, 1345, 1346,
	      1345, 1345, 1344, 1344, 1345, 1345, 1343, 1344, 1344, 1345,
	      1345, 1347, 1347, 1349, 1351, 1354, 1356, 1359, 1361, 1361,
	      1363, 1364, 1366, 1368, 1368, 1366, 1366, 1365, 1365, 1364,
	      1364, 1367, 1369, 1370, 1370, 1369, 1369, 1368, 1368, 1367,
	      1367, 1366, 1364, 1363, 1362, 1362, 1361, 1361, 1360, 1358,
	      1358, 1359, 1359, 1358, 1359, 1359, 1358, 1356, 1354, 1348,
	      1346, 1343, 1342, 1341, 1341, 1340, 1340, 1339, 1339, 1338,
	      1338, 1337, 1314, 1312, 1314, 1315, 1316, 1315, 1313, 1310,
	      1308, 1306, 1305, 1301, 1296, 1294, 1292, 1290, 1286, 1283,
	      1282, 1282, 1278, 1278, 1277, 1276, 1274, 1273, 1273, 1274,
	      1274, 1271, 1266, 1264, 1264, 1263, 1259, 1258, 1258, 1259,
	      1258, 1258, 1260, 1266, 1265, 1265, 1264, 1264, 1262, 1258,
	      1258, 1257, 1257, 1252, 1250, 1250, 1249, 1244, 1242, 1240,
	      1238, 1237, 1236, 1234, 1233, 1232, 1230, 1228, 1226, 1226,
	      1224, 1223, 1222, 1222, 1221, 1222, 1222, 1223, 1225, 1226,
	      1228, 1229, 1230, 1232, 1235, 1236, 1238, 1240, 1240, 1239,
	      1236, 1235, 1235, 1234, 1234, 1233, 1232, 1231, 1227, 1226,
	      1227, 1229, 1229, 1228, 1226, 1226, 1225, 1222, 1222, 1220,
	      1219, 1215, 1211, 1208, 1208, 1207, 1206, 1207, 1207, 1206,
	      1203, 1200, 1200, 1198, 1198, 1194, 1194, 1195, 1195, 1192,
	      1192, 1190, 1190, 1188, 1185, 1183, 1182, 1180, 1179, 1178,
	      1178, 1179, 1179, 1177, 1174, 1173, 1172, 1172, 1171, 1168,
	      1167, 1167, 1168, 1168, 1167, 1167, 1168, 1170, 1173, 1173,
	      1174, 1176, 1177, 1177, 1178, 1177, 1177, 1175, 1172, 1165,
	      1163, 1159, 1158, 1158, 1157, 1157, 1158, 1159, 1157, 1156,
	      1155, 1121, 1119, 1116, 1115, 1113, 1110, 1109, 1106, 1106,
	      1103, 1102, 1102, 1099, 1098, 1086, 1083, 1081, 1071, 1071,
	      1070, 1065, 1063, 1063, 1039, 1037, 1037, 1034, 1033, 1032,
	      1031, 1029, 1027, 1026, 1025, 1022, 1019, 1014, 1013, 1006,
	      1005, 998, 991, 990, 989, 986, 983, 980, 973, 965, 957, 955,
	      948, 947, 942, 940, 937, 913, 908, 901, 898, 894),
	  y = c(529, 527, 528, 528, 530, 530, 532, 534, 535, 537, 540, 543,
	      545, 546, 547, 548, 546, 542, 540, 539, 535, 534, 533, 533,
	      535, 537, 538, 542, 544, 545, 551, 556, 556, 557, 557, 558,
	      560, 563, 565, 573, 575, 575, 577, 578, 580, 582, 583, 584,
	      586, 587, 589, 590, 592, 593, 596, 597, 598, 600, 602, 604,
	      607, 609, 612, 620, 624, 630, 638, 642, 649, 652, 653, 655,
	      655, 656, 659, 659, 660, 660, 659, 662, 662, 663, 663, 664,
	      664, 665, 666, 666, 667, 667, 665, 664, 664, 663, 663, 662,
	      663, 663, 662, 660, 658, 658, 657, 657, 658, 658, 661, 663,
	      668, 671, 674, 679, 680, 682, 683, 686, 688, 691, 694, 697,
	      700, 702, 703, 702, 702, 703, 709, 714, 718, 721, 723, 729,
	      731, 733, 735, 735, 731, 727, 726, 723, 721, 717, 713, 709,
	      707, 703, 698, 691, 689, 686, 682, 682, 684, 684, 682, 682,
	      681, 681, 679, 679, 677, 677, 681, 685, 693, 696, 696, 697,
	      697, 696, 696, 695, 695, 694, 695, 695, 699, 703, 709, 710,
	      712, 720, 722, 720, 720, 721, 723, 726, 737, 738, 740, 740,
	      749, 751, 751, 754, 754, 757, 757, 760, 762, 764, 766, 770,
	      771, 776, 778, 779, 780, 782, 786, 789, 789, 792, 793, 795,
	      798, 798, 804, 807, 809, 810, 815, 816, 818, 820, 823, 826,
	      831, 827, 821, 819, 810, 809, 808, 801, 799, 798, 798, 792,
	      791, 788, 786, 785, 783, 782, 781, 781, 780, 779, 777, 775,
	      759, 757, 757, 758, 756, 755, 754, 754, 753, 753, 752, 750,
	      745, 745, 744, 742, 740, 737, 735, 732, 728, 727, 726, 724,
	      724, 722, 720, 720, 719, 719, 717, 715, 714, 712, 708, 706,
	      704, 703, 703, 702, 703, 703, 702, 700, 698, 693, 693, 696,
	      697, 697, 698, 698, 696, 693, 693, 698, 701, 703, 707, 707,
	      708, 708, 709, 711, 712, 714, 715, 714, 712, 712, 713, 714,
	      716, 718, 719, 720, 720, 718, 717, 717, 714, 712, 712, 710,
	      710, 712, 713, 714, 714, 713, 712, 714, 728, 731, 731, 733,
	      734, 735, 739, 742, 745, 747, 747, 748, 750, 753, 754, 754,
	      756, 758, 761, 761, 762, 764, 765, 768, 777, 779, 782, 783,
	      785, 787, 788, 788, 787, 786, 785, 785, 786, 786, 787, 787,
	      789, 789, 790, 791, 792, 792, 791, 789, 787, 788, 794, 794,
	      796, 800, 801, 801, 803, 804, 806, 808, 810, 812, 812, 811,
	      807, 806, 807, 808, 809, 814, 815, 815, 816, 819, 822, 822,
	      821, 821, 822, 825, 828, 829, 830, 830, 834, 837, 838, 838,
	      839, 839, 840, 844, 845, 847, 848, 849, 851, 850, 851, 851,
	      852, 852, 849, 848, 848, 846, 844, 845, 846, 849, 852, 854,
	      856, 857, 858, 858, 859, 860, 860, 862, 863, 864, 867, 869,
	      870, 870, 871, 871, 868, 868, 867, 866, 866, 865, 865, 868,
	      868, 869, 869, 868, 866, 866, 865, 865, 864, 864, 863, 863)),
     list(x = c(894, 894), y = c(863, 1157)),
     list(x = c(894, 894), y = c(1157, 1744)),
     list(x = c(894, 1367), y = c(1157, 1157)),
     list(x = c(1367, 1367), y = c(1157, 1663)),
     list(x = c(1367, 1525, 1525 ), y = c(1157, 1157, 999)),
     list(x = c(2181, 2181, 2178, 2177, 2174, 2173, 2172, 2171, 2169, 2168,
	      2167, 2166, 2164, 2164, 2161, 2161, 2158, 2158, 2152, 2151,
	      2142, 2142, 2137, 2135, 2132, 2130, 2131, 2130, 2130, 2128,
	      2127, 2126, 2125, 2124, 2123, 2122, 2121, 2118, 2117, 2112,
	      2111, 2109, 2109, 2108, 2106, 2106, 2107, 2107, 2108, 2108,
	      2109, 2109, 2110, 2110, 2109, 2109, 2108, 2107, 2102, 2099,
	      2098, 2098, 2094, 2093, 2092, 2091, 2088, 2087, 2085, 2083,
	      2082, 2082, 2081, 2081, 2080, 2080, 2077, 2073, 2072, 2072,
	      2071, 2070, 2070, 2069, 2069, 2068, 2068, 2067, 2067, 2066,
	      2066, 2065, 2063, 2060, 2059, 2058, 2058, 2054, 2053, 2052,
	      2052, 2051, 2050, 2048, 2046, 2043, 2043, 2040, 2039, 2037,
	      2036, 2032, 2031, 2028, 2026, 2025, 2023, 2022, 2022, 2021,
	      2016, 2016, 2008, 2007, 1999, 1998, 1996, 1995, 1992, 1991,
	      1988, 1987, 1986, 1986, 1985, 1983, 1983, 1982, 1982, 1979,
	      1979, 1978, 1977, 1977, 1975, 1974, 1974, 1973, 1973, 1972,
	      1972, 1971, 1969, 1967, 1966, 1964, 1964, 1961, 1960, 1958,
	      1958, 1957, 1957, 1956, 1956, 1955, 1955, 1954, 1954, 1953,
	      1953, 1952, 1952, 1951, 1946, 1525),
	  y = c(1044, 1043, 1043, 1042, 1042, 1041, 1041, 1040, 1040, 1039,
	      1039, 1038, 1038, 1037, 1037, 1036, 1036, 1035, 1035, 1036,
	      1036, 1037, 1037, 1038, 1038, 1036, 1036, 1035, 1033, 1032,
	      1031, 1031, 1030, 1030, 1029, 1029, 1028, 1028, 1027, 1027,
	      1026, 1026, 1025, 1025, 1023, 1021, 1020, 1019, 1018, 1016,
	      1015, 1012, 1011, 1009, 1008, 1007, 1005, 1004, 1004, 1005,
	      1005, 1006, 1006, 1005, 1005, 1004, 1004, 1003, 1003, 1001,
	      1001, 1000, 999, 994, 994, 993, 990, 990, 991, 992, 993, 993,
	      995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1003, 1004,
	      1007, 1007, 1009, 1010, 1014, 1014, 1015, 1016, 1016, 1017,
	      1017, 1018, 1018, 1017, 1017, 1016, 1016, 1015, 1015, 1016,
	      1016, 1018, 1018, 1020, 1020, 1021, 1020, 1020, 1019, 1019,
	      1018, 1018, 1019, 1019, 1020, 1020, 1021, 1021, 1022, 1022,
	      1023, 1024, 1024, 1025, 1025, 1024, 1024, 1023, 1022, 1022,
	      1021, 1019, 1019, 1018, 1018, 1017, 1017, 1016, 1016, 1014,
	      1014, 1013, 1013, 1012, 1012, 1011, 1011, 1009, 1009, 1008,
	      1008, 1007, 1007, 1005, 1005, 1004, 1003, 1002, 1002, 1001,
	      1000, 999, 999)),
     list(x = c( 1525, 1525), y = c(999, 733)),
     list(x = c(1980, 1895, 1891, 1891, 1890, 1890, 1889, 1889, 1888, 1888,
	      1887, 1887, 1886, 1884, 1883, 1882, 1880, 1880, 1879, 1877,
	      1873, 1872, 1869, 1867, 1865, 1863, 1859, 1857, 1856, 1854,
	      1844, 1844, 1843, 1843, 1842, 1842, 1840, 1836, 1835, 1833,
	      1833, 1829, 1828, 1827, 1825, 1824, 1823, 1821, 1821, 1818,
	      1818, 1816, 1816, 1814, 1813, 1811, 1810, 1808, 1807, 1806,
	      1805, 1804, 1803, 1798, 1797, 1793, 1791, 1785, 1784, 1782,
	      1781, 1780, 1778, 1773, 1771, 1769, 1768, 1766, 1765, 1765,
	      1763, 1761, 1760, 1759, 1758, 1757, 1756, 1754, 1751, 1750,
	      1744, 1743, 1741, 1741, 1734, 1734, 1733, 1730, 1730, 1729,
	      1729, 1728, 1727, 1727, 1726, 1725, 1719, 1718, 1715, 1711,
	      1710, 1709, 1709, 1708, 1707, 1707, 1706, 1706, 1705, 1705,
	      1704, 1704, 1701, 1700, 1699, 1698, 1697, 1696, 1695, 1695,
	      1693, 1693, 1691, 1691, 1690, 1688, 1687, 1687, 1686, 1684,
	      1683, 1682, 1679, 1679, 1677, 1675, 1674, 1673, 1672, 1671,
	      1669, 1669, 1667, 1666, 1665, 1664, 1663, 1663, 1662, 1658,
	      1657, 1656, 1655, 1654, 1654, 1652, 1652, 1651, 1651, 1652,
	      1652, 1653, 1653, 1652, 1652, 1651, 1650, 1650, 1649, 1649,
	      1648, 1648, 1647, 1647, 1646, 1646, 1640, 1639, 1636, 1635,
	      1628, 1628, 1627, 1626, 1626, 1623, 1623, 1621, 1621, 1620,
	      1619, 1619, 1618, 1618, 1617, 1617, 1616, 1614, 1614, 1613,
	      1612, 1611, 1611, 1610, 1610, 1609, 1609, 1608, 1606, 1606,
	      1605, 1605, 1601, 1601, 1600, 1600, 1601, 1601, 1602, 1602,
	      1601, 1600, 1599, 1597, 1596, 1595, 1594, 1594, 1593, 1593,
	      1592, 1590, 1587, 1586, 1585, 1585, 1584, 1584, 1583, 1583,
	      1582, 1581, 1580, 1579, 1577, 1577, 1576, 1572, 1571, 1566,
	      1565, 1564, 1557, 1553, 1552, 1551, 1550, 1549, 1549, 1548,
	      1543, 1542, 1539, 1539, 1537, 1536, 1534, 1534, 1530, 1528,
	      1526, 1525),
	  y = c(556, 603, 607, 608, 608, 612, 612, 623, 623, 625, 626, 627,
	      627, 629, 629, 630, 630, 631, 631, 633, 633, 634, 634, 633,
	      633, 634, 634, 632, 632, 630, 630, 629, 629, 628, 628, 627,
	      625, 625, 626, 626, 627, 627, 628, 628, 629, 629, 630, 630,
	      631, 631, 632, 632, 633, 633, 634, 634, 635, 635, 634, 634,
	      633, 633, 632, 632, 631, 631, 632, 632, 633, 633, 634, 634,
	      636, 636, 637, 639, 639, 640, 640, 641, 641, 643, 643, 644,
	      644, 645, 645, 644, 644, 643, 643, 644, 644, 645, 645, 644,
	      644, 641, 640, 639, 634, 632, 631, 630, 630, 629, 629, 630,
	      630, 634, 634, 635, 636, 636, 637, 638, 638, 639, 639, 641,
	      642, 644, 647, 647, 648, 648, 649, 649, 650, 651, 651, 652,
	      654, 655, 655, 657, 657, 658, 658, 659, 659, 660, 660, 661,
	      661, 663, 663, 664, 664, 665, 665, 666, 666, 667, 667, 668,
	      668, 675, 676, 676, 677, 677, 678, 678, 679, 681, 684, 685,
	      689, 690, 692, 693, 694, 695, 696, 697, 697, 698, 699, 700,
	      700, 701, 701, 702, 702, 703, 703, 704, 704, 705, 705, 706,
	      707, 707, 709, 709, 711, 711, 712, 711, 711, 710, 710, 703,
	      702, 701, 701, 699, 698, 698, 699, 699, 701, 701, 703, 703,
	      704, 704, 706, 708, 709, 711, 711, 713, 713, 717, 718, 719,
	      720, 721, 722, 722, 723, 723, 724, 724, 725, 729, 730, 731,
	      731, 732, 732, 731, 731, 732, 733, 735, 735, 736, 736, 737,
	      736, 736, 735, 736, 735, 735, 736, 736, 737, 737, 730, 730,
	      731, 731, 732, 732, 733, 734, 734, 735, 735, 734, 734, 735,
	      736, 738, 738, 740, 740, 733)),
     list(x = c(1525, 1522, 1522), y = c(733, 729, 529 )))
