#' Precipitation density
#'
#' Function for plotting (density) time-series of area averaged precipitation.
#'
#' @import data.table ggplot2
#' @importFrom methods as
#' @importFrom stats density
#' @param dummie a csv generated by \code{\link{make_ts}}
#' @return ggplot object
#' @export

plot_density <- function(dummie){
  dummie <- as.data.table(dummie)
  p00 <- ggplot(dummie, aes(x = value, after_stat(density))) +
    geom_histogram(color = "gray", fill = "#377eb8") +
    geom_density(color = "black", size = 1, linetype = "dashed") +
    theme_bw() +
    labs(y = "Density", x = "Precipitation [mm]") + 
    theme(plot.title = element_text(size=24),
          axis.text = element_text(size = 20),
          axis.title = element_text(size = 24))
  return(p00)
}