% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRep3.R
\name{pRep3}
\alias{pRep3}
\title{Third series of p-rep designs}
\usage{
pRep3(v, p)
}
\arguments{
\item{v}{Total number of treatments or breeding lines or entries}

\item{p}{positive integer (>=2)}
}
\value{
This function generates a new series of p-rep designs with parameters:

v = 6p : number of treatments,

e = 2 : number of environments,

b = 6 : blocks of size k = 3p and

r = 3 : number of replications.

Canonical efficiency factor and average variance factor of the generated p-rep design.
}
\description{
For the specified values of v and p, this function generates a series of p-rep designs. The input should meet the condition that v=6*p where, p>=2.
}
\examples{
library(pRepDesigns)
pRep3(18, 2)

}
\references{
Williams E, Piepho HP, Whitaker D (2011)<https://doi.org/10.1002/bimj.201000102>
}
