% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{check_trans_prob}
\alias{check_trans_prob}
\title{Check the transition probabilities for numeric values and unity  row sum}
\usage{
check_trans_prob(trans_mat)
}
\arguments{
\item{trans_mat}{transition matrix}
}
\value{
0 if they add to 1 else error
}
\description{
Check the transition probabilities for numeric values and unity  row sum
}
\details{
checking for rowsum - checks for the class of transition matrix,
value of rowsum (to be 1) and numeric values
}
\examples{
tmat <- rbind(c(1, 2), c(3, 4))
colnames(tmat) <- rownames(tmat) <- c("Healthy", "Dead")
tm <- populate_transition_matrix(2, tmat, list_prob = c(0.5, 0.5, 0, 1))
check_trans_prob(tm)
}
