% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packageRankTime.R
\name{packageRankTime}
\alias{packageRankTime}
\title{Package download counts and rank percentiles (longitudinal).}
\usage{
packageRankTime(packages = "HistData", when = "last-month",
  sample.pct = 5, multi.core = FALSE)
}
\arguments{
\item{packages}{Character. Character. Vector of package name(s).}

\item{when}{Character. "last-month" or "last-week".}

\item{sample.pct}{Numeric.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. On Windows, only \code{multi.core = FALSE} is available.}
}
\description{
Temporal pattern over last week or month.
}
\note{
Most useful with plot() method. packageRankTime() takes longer to run because it replicates cranlogs::cran_downloads(when = "last-week" or "last-month") with additional computation for ranks and cohort.
}
\examples{
\donttest{

packageRankTime(packages = "HistData", when = "last-week")
packageRankTime(packages = c("Rcpp", "rlang"), when = "last-month")
}
}
