% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitlab.R
\name{get_gitlab_log}
\alias{get_gitlab_log}
\title{Read a \verb{gitlab} Check Log}
\usage{
get_gitlab_log(user, project, private_token, ...)
}
\arguments{
\item{user}{The user's name on \verb{gitlab}.}

\item{project}{The project's name on \verb{gitlab}.}

\item{private_token}{The user's private token on \verb{gitlab}.}

\item{...}{Arguments passed to \code{\link[httr:GET]{httr::GET}}.}
}
\value{
A character vector containing the lines of the \verb{gitlab} log.
}
\description{
For a given user's project, the last log for jobs for name and stage "check"
will be read. This is assumed to be the output of \command{R CMD check},
\code{\link[rcmdcheck:rcmdcheck]{rcmdcheck::rcmdcheck}}
\code{\link[devtools:check]{devtools::check}}, or the like.
}
\examples{
\dontrun{
gitlab_token <- readLines(file.path("~", ".gitlab_private_token.txt"))
if (Sys.info()[["nodename"]] == "fvafrdebianCU") {
    j <- get_gitlab_log(user = "fvafrcu", project = "packager",
                        private_token = gitlab_token,
                        httr::use_proxy("10.127.255.17", 8080))
} else {
    j <- get_gitlab_log(user = "fvafrcu", project = "packager",
                        private_token = gitlab_token)
}

cat(j, sep = "\n")
}
}
\keyword{internal}
