% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_comments.R
\name{provide_cran_comments}
\alias{provide_cran_comments}
\title{Provide a Template for Your Comments To CRAN}
\usage{
provide_cran_comments(
  check_log = NULL,
  path = ".",
  initial = FALSE,
  write_to_file = TRUE,
  private_token = NULL,
  name = NA,
  proxy = NULL
)
}
\arguments{
\item{check_log}{Deprecated, will be removed in a future release.
The local R CMD check log is now supposed to live be
`log/check.(log|Rout)`.}

\item{path}{Path to the package directory (see
\code{\link[devtools:as.package]{devtools::as.package}}).}

\item{initial}{Is this an initial submission?}

\item{write_to_file}{Do write the comment to \file{cran-comment.md}?}

\item{private_token}{Provide a private token to access
\url{https://about.gitlab.com}.}

\item{name}{The name to sign with, if NA, the given name of the package
maintainer as stated in file DESCRIPTION is used.}

\item{proxy}{A proxy to use.}
}
\value{
Character vector containing the \acronym{CRAN} comments, which are
written to \file{cran-comments.md} (see Note).
}
\description{
\code{\link{submit}} reads a file \file{cran-comments.md}. This
function provides a template based on your R version, your
\command{R CMD check} output and
the package's \file{NEWS.md}.
}
\note{
By default this function writes to disk as side effect.
}
\examples{
\dontrun{

if (Sys.info()[["nodename"]] == "fvafrdebianCU") {
    gitlab_token <- readLines(file.path("~", ".gitlab_private_token.txt"))
    proxy <- httr::use_proxy("10.127.255.17", 8080)
    comments <- provide_cran_comments(path = ".",
                                      write_to_file = TRUE,
                                      private_token = gitlab_token,
                                      proxy = proxy)

} else {
    gitlab_token <- readLines(file.path("~", ".gitlab_private_token.txt"))
    comments <- provide_cran_comments(path = ".",
                                      write_to_file = TRUE)#,
                                      private_token = gitlab_token)
}
cat(comments, sep = "")
}
}
