% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PACo.r
\name{PACo}
\alias{PACo}
\title{Performs PACo/procustes analysis}
\usage{
PACo(D, nperm = 1000, seed = NA, method = "r0", symmetric = FALSE,
  correction = "none")
}
\arguments{
\item{D}{a list with the data}

\item{nperm}{Number of permutations}

\item{seed}{Seed if results need to be reproduced}

\item{method}{The method to permute matrices with: "r0", "r1", "r2", "c0", "swap", "quasiswap", "backtrack", "tswap", "r00". See \code{\link[vegan]{commsim}} for details}

\item{symmetric}{Use symmetric Procrustes statistic}

\item{correction}{Choose the method with which to correct negative eigenvalues in the internal call of add_pcoord ('none', cailliez', 'lingoes'). Default is 'none'.}
}
\description{
Performs PACo/procustes analysis
}
\examples{
data(gopherlice)
require(ape)
gdist <- cophenetic(gophertree)
ldist <- cophenetic(licetree)
D <- prepare_paco_data(gdist, ldist, gl_links)
D <- add_pcoord(D)
D <- PACo(D, nperm=10, seed=42, method="r0", correction='cailliez')
print(D$gof)
}

